/*
 * Decompiled with CFR 0.152.
 */
package org.apache.niolex.commons.bean;

import com.google.common.collect.Maps;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.apache.niolex.commons.concurrent.ConcurrentUtil;
import org.apache.niolex.commons.test.ObjToStringUtil;

public class BeanUtil {
    private static final ConcurrentHashMap<Class<?>, BeanInfo> beanInfoMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, Method>> writeMethodsMap = new ConcurrentHashMap();

    public static final String toString(Object obj) {
        return ObjToStringUtil.objToString(obj);
    }

    public static final byte[] toBytes(Serializable s) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(s);
        oos.close();
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object toObject(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        try (ObjectInputStream ois = new ObjectInputStream(bis);){
            Object object = ois.readObject();
            return object;
        }
    }

    public static final <To, From> To merge(To to, From from) {
        return BeanUtil.merge(to, from, false);
    }

    public static final <To, From> To merge(To to, From from, boolean mergeDefault) {
        try {
            Map<String, Method> writeMap = BeanUtil.prepareWriteMethodMap(to.getClass());
            BeanInfo fromInfo = BeanUtil.getBeanInfo(from.getClass());
            for (PropertyDescriptor descriptor : fromInfo.getPropertyDescriptors()) {
                Object value;
                Method writeMethod;
                Method readMethod = descriptor.getReadMethod();
                if (readMethod == null || (writeMethod = writeMap.get(descriptor.getName())) == null || (value = readMethod.invoke(from, new Object[0])) == null || !mergeDefault && BeanUtil.isNumericPrimitiveDefaultValue(readMethod.getReturnType(), value) || !ClassUtils.isAssignable(value.getClass(), writeMethod.getParameterTypes()[0], (boolean)true)) continue;
                writeMethod.invoke(to, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to merge propeties.", e);
        }
        return to;
    }

    public static Map<String, Method> prepareWriteMethodMap(Class<?> toClass) throws IntrospectionException {
        HashMap writeMap = writeMethodsMap.get(toClass);
        if (writeMap != null) {
            return writeMap;
        }
        BeanInfo toInfo = BeanUtil.getBeanInfo(toClass);
        writeMap = Maps.newHashMap();
        for (PropertyDescriptor descriptor : toInfo.getPropertyDescriptors()) {
            Method writeMethod = descriptor.getWriteMethod();
            if (writeMethod == null) continue;
            writeMap.put(descriptor.getName(), writeMethod);
        }
        writeMethodsMap.putIfAbsent(toClass, writeMap);
        return writeMap;
    }

    public static BeanInfo getBeanInfo(Class<?> beanClass) throws IntrospectionException {
        BeanInfo info = beanInfoMap.get(beanClass);
        if (info == null) {
            info = ConcurrentUtil.initMap(beanInfoMap, beanClass, Introspector.getBeanInfo(beanClass));
        }
        return info;
    }

    public static boolean isNumericPrimitiveDefaultValue(Class<?> type, Object value) {
        Number num;
        return type.isPrimitive() && Number.class.isInstance(value) && (num = (Number)Number.class.cast(value)).doubleValue() == 0.0;
    }

    public static final <To> To merge(To to, Map<String, Object> from) {
        try {
            Map<String, Method> writeMap = BeanUtil.prepareWriteMethodMap(to.getClass());
            for (Map.Entry<String, Object> entry : from.entrySet()) {
                Object value;
                Method writeMethod = writeMap.get(entry.getKey());
                if (writeMethod == null || !ClassUtils.isAssignable((value = entry.getValue()).getClass(), writeMethod.getParameterTypes()[0], (boolean)true)) continue;
                writeMethod.invoke(to, value);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to merge propeties.", e);
        }
        return to;
    }
}

