/*
 * Decompiled with CFR 0.152.
 */
package com.petterp.floatingx.view;

import android.content.res.Configuration;
import com.petterp.floatingx.assist.helper.BasisHelper;
import com.petterp.floatingx.util.FxExtKt;
import com.petterp.floatingx.view.FxViewConfigHelper;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0018\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0019\u001a\u00020\u0006J\u001e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u0012J\u000e\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u001dR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/petterp/floatingx/view/FxLocationHelper;", "", "()V", "config", "Lcom/petterp/floatingx/assist/helper/BasisHelper;", "isInitLocation", "", "isNearestLeft", "screenChanged", "screenH", "", "screenW", "x", "", "y", "getLocation", "Lkotlin/Pair;", "viewConfig", "Lcom/petterp/floatingx/view/FxViewConfigHelper;", "getX", "min", "max", "getY", "initConfig", "", "isRestoreLocation", "saveLocation", "configHelper", "updateConfig", "Landroid/content/res/Configuration;", "floatingx_release"})
public final class FxLocationHelper {
    private BasisHelper config;
    private int screenW;
    private int screenH;
    private float x;
    private float y;
    private boolean isNearestLeft;
    private boolean screenChanged;
    private boolean isInitLocation = true;

    public final void initConfig(@NotNull BasisHelper config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    public final boolean isRestoreLocation() {
        return this.screenChanged;
    }

    public final boolean isInitLocation() {
        if (this.isInitLocation) {
            this.isInitLocation = false;
            return true;
        }
        return false;
    }

    @NotNull
    public final FxLocationHelper saveLocation(float x, float y, @NotNull FxViewConfigHelper configHelper) {
        Intrinsics.checkNotNullParameter((Object)configHelper, (String)"configHelper");
        this.x = x;
        this.y = y;
        this.isNearestLeft = configHelper.isNearestLeft(x);
        return this;
    }

    public final boolean updateConfig(@NotNull Configuration config) {
        boolean isChangedScreen;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (config.screenWidthDp != this.screenW || config.screenHeightDp != this.screenH) {
            this.screenW = config.screenWidthDp;
            this.screenH = config.screenHeightDp;
            bl = true;
        } else {
            bl = false;
        }
        this.screenChanged = isChangedScreen = bl;
        return this.screenChanged;
    }

    @NotNull
    public final Pair<Float, Float> getLocation(@NotNull FxViewConfigHelper viewConfig) {
        Intrinsics.checkNotNullParameter((Object)viewConfig, (String)"viewConfig");
        float newX = this.getX(viewConfig.getMinWBoundary(), viewConfig.getMinWBoundary());
        float newY = this.getY(viewConfig.getMinHBoundary(), viewConfig.getMaxHBoundary());
        this.screenChanged = false;
        return TuplesKt.to((Object)Float.valueOf(newX), (Object)Float.valueOf(newY));
    }

    private final float getX(float min, float max) {
        BasisHelper basisHelper = this.config;
        if (basisHelper == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"config");
            throw null;
        }
        return basisHelper.enableEdgeAdsorption ? (this.isNearestLeft ? min : max) : FxExtKt.coerceInFx(this.x, min, max);
    }

    private final float getY(float min, float max) {
        return FxExtKt.coerceInFx(this.y, min, max);
    }
}

