/*
 * Decompiled with CFR 0.152.
 */
package setup;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.file.RelativePath;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\fH\u0007J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0002J\b\u0010\u0015\u001a\u00020\fH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lsetup/NodeSetupTask;", "Lorg/gradle/api/DefaultTask;", "()V", "nodeArchiveFile", "Lorg/gradle/api/file/RegularFileProperty;", "getNodeArchiveFile", "()Lorg/gradle/api/file/RegularFileProperty;", "nodeDir", "Lorg/gradle/api/file/DirectoryProperty;", "getNodeDir", "()Lorg/gradle/api/file/DirectoryProperty;", "copyNodeInstallContent", "", "archiveTree", "Lorg/gradle/api/file/FileTree;", "deleteExistingNode", "exec", "fixBrokenSymlink", "name", "", "setExecutableFlag", "unpackNodeArchive", "Companion", "GradleNpmPlugin"})
public abstract class NodeSetupTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String NAME = "nodeSetup";

    public NodeSetupTask() {
        this.setDescription("Download and install a local node/npm version.");
    }

    @InputFile
    @NotNull
    public abstract RegularFileProperty getNodeArchiveFile();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getNodeDir();

    @TaskAction
    public final void exec() {
        this.deleteExistingNode();
        this.unpackNodeArchive();
        this.setExecutableFlag();
    }

    private final void deleteExistingNode() {
        this.getProject().delete(new Action(this){
            final /* synthetic */ NodeSetupTask this$0;
            {
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull DeleteSpec $this$delete) {
                Intrinsics.checkNotNullParameter((Object)$this$delete, (String)"$this$delete");
                Object[] objectArray = new Object[]{this.this$0.getNodeDir()};
                $this$delete.delete(objectArray);
            }
        });
        this.getLogger().debug("{} cleaned", (Object)this.getNodeDir());
    }

    private final void unpackNodeArchive() {
        File file = ((RegularFile)this.getNodeArchiveFile().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeArchiveFile.get().asFile");
        File archiveFile = file;
        String string = archiveFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"archiveFile.name");
        if (StringsKt.endsWith$default((String)string, (String)"zip", (boolean)false, (int)2, null)) {
            FileTree fileTree = this.getProject().zipTree((Object)archiveFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.zipTree(archiveFile)");
            this.copyNodeInstallContent(fileTree);
        } else {
            FileTree fileTree = this.getProject().tarTree((Object)archiveFile);
            Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"project.tarTree(archiveFile)");
            this.copyNodeInstallContent(fileTree);
            this.fixBrokenSymlink("npm");
            this.fixBrokenSymlink("npx");
        }
    }

    private final void copyNodeInstallContent(FileTree archiveTree) {
        this.getLogger().debug("Extracting node archive: {} into {}", (Object)archiveTree, (Object)this.getNodeDir());
        this.getProject().copy(new Action(archiveTree, this){
            final /* synthetic */ FileTree $archiveTree;
            final /* synthetic */ NodeSetupTask this$0;
            {
                this.$archiveTree = $archiveTree;
                this.this$0 = $receiver;
            }

            public final void execute(@NotNull CopySpec $this$copy) {
                Intrinsics.checkNotNullParameter((Object)$this$copy, (String)"$this$copy");
                $this$copy.from((Object)this.$archiveTree, new Action(this.this$0){
                    final /* synthetic */ NodeSetupTask this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final void execute(@NotNull CopySpec $this$from) {
                        Intrinsics.checkNotNullParameter((Object)$this$from, (String)"$this$from");
                        $this$from.eachFile(new Action(this.this$0){
                            final /* synthetic */ NodeSetupTask this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final void execute(@NotNull FileCopyDetails $this$eachFile) {
                                Intrinsics.checkNotNullParameter((Object)$this$eachFile, (String)"$this$eachFile");
                                String[] stringArray = $this$eachFile.getRelativePath().getSegments();
                                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"relativePath.segments");
                                Collection $this$toTypedArray$iv = ArraysKt.drop((Object[])stringArray, (int)1);
                                boolean $i$f$toTypedArray = false;
                                Collection thisCollection$iv = $this$toTypedArray$iv;
                                String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                                $this$eachFile.setRelativePath(new RelativePath(true, Arrays.copyOf(stringArray2, stringArray2.length)));
                                this.this$0.getLogger().debug("Extracting file: {}", (Object)$this$eachFile.getRelativePath());
                            }
                        });
                        $this$from.setIncludeEmptyDirs(false);
                    }
                });
                $this$copy.into((Object)this.this$0.getNodeDir());
            }
        });
    }

    private final void fixBrokenSymlink(String name) {
        Path binPath = ((Directory)this.getNodeDir().dir("bin").get()).getAsFile().toPath();
        Path scriptPath = binPath.resolve(name);
        if (Files.deleteIfExists(scriptPath)) {
            Path targetPath = ((Directory)this.getNodeDir().dir("lib/node_modules/npm/bin/" + name + "-cli.js").get()).getAsFile().toPath();
            Path fixedScriptPath = binPath.relativize(targetPath);
            Files.createSymbolicLink(scriptPath, fixedScriptPath, new FileAttribute[0]);
            this.getLogger().debug("Fixed broken symlink: {} with target {}", (Object)name, (Object)fixedScriptPath);
        }
    }

    private final void setExecutableFlag() {
        if (!Os.isFamily((String)"windows")) {
            File file = ((RegularFile)this.getNodeDir().file("bin/node").get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"nodeDir.file(\"bin/node\").get().asFile");
            File nodeExec = file;
            nodeExec.setExecutable(true, false);
            this.getLogger().debug("Set executable flag on {}", (Object)nodeExec);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lsetup/NodeSetupTask$Companion;", "", "()V", "NAME", "", "GradleNpmPlugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

