/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.ReentrantLock;
import org.iq80.leveldb.Snapshot;

final class SnapshotList {
    private final ReentrantLock mutex;
    private final SnapshotNode list;

    public SnapshotList(ReentrantLock mutex) {
        this.mutex = mutex;
        this.list = new SnapshotNode(0L);
        this.list.next = this.list;
        this.list.prev = this.list;
    }

    public Snapshot newSnapshot(long sequence) {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        SnapshotNode s = new SnapshotNode(sequence);
        s.next = this.list;
        s.prev = this.list.prev;
        s.prev.next = s;
        s.next.prev = s;
        return s;
    }

    public boolean isEmpty() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        return this.list.next == this.list;
    }

    public long getOldest() {
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        Preconditions.checkState((!this.isEmpty() ? 1 : 0) != 0);
        return this.list.next.number;
    }

    public long getSequenceFrom(Snapshot snapshot) {
        Preconditions.checkArgument((boolean)(snapshot instanceof SnapshotNode));
        Preconditions.checkState((boolean)this.mutex.isHeldByCurrentThread());
        return ((SnapshotNode)snapshot).number;
    }

    private final class SnapshotNode
    implements Snapshot {
        private final long number;
        private SnapshotNode next;
        private SnapshotNode prev;

        private SnapshotNode(long number) {
            this.number = number;
        }

        public void close() {
            SnapshotList.this.mutex.lock();
            try {
                this.prev.next = this.next;
                this.next.prev = this.prev;
            }
            finally {
                SnapshotList.this.mutex.unlock();
            }
        }
    }
}

