/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Objects;
import org.iq80.leveldb.env.Env;
import org.iq80.leveldb.env.File;

public final class Filename {
    private Filename() {
    }

    public static String logFileName(long number) {
        return Filename.makeFileName(number, "log");
    }

    public static String tableFileName(long number) {
        return Filename.makeFileName(number, "ldb");
    }

    public static String sstTableFileName(long number) {
        return Filename.makeFileName(number, "sst");
    }

    public static String descriptorFileName(long number) {
        Preconditions.checkArgument((number >= 0L ? 1 : 0) != 0, (Object)"number is negative");
        return String.format("MANIFEST-%06d", number);
    }

    public static String currentFileName() {
        return "CURRENT";
    }

    public static String lockFileName() {
        return "LOCK";
    }

    public static String tempFileName(long number) {
        return Filename.makeFileName(number, "dbtmp");
    }

    public static String infoLogFileName() {
        return "LOG";
    }

    public static String oldInfoLogFileName() {
        return "LOG.old";
    }

    public static FileInfo parseFileName(File file) {
        try {
            String fileName = file.getName();
            if ("CURRENT".equals(fileName)) {
                return new FileInfo(FileType.CURRENT);
            }
            if ("LOCK".equals(fileName)) {
                return new FileInfo(FileType.DB_LOCK);
            }
            if ("LOG".equals(fileName) || "LOG.old".equals(fileName)) {
                return new FileInfo(FileType.INFO_LOG);
            }
            if ("LOG.old".equals(fileName)) {
                return new FileInfo(FileType.INFO_LOG);
            }
            if (fileName.startsWith("MANIFEST-")) {
                long fileNumber = Filename.parseLong(Filename.removePrefix(fileName, "MANIFEST-"));
                return new FileInfo(FileType.DESCRIPTOR, fileNumber);
            }
            if (fileName.endsWith(".log")) {
                long fileNumber = Filename.parseLong(Filename.removeSuffix(fileName, ".log"));
                return new FileInfo(FileType.LOG, fileNumber);
            }
            if (fileName.endsWith(".sst") || fileName.endsWith(".ldb")) {
                long fileNumber = Filename.parseLong(fileName.substring(0, fileName.lastIndexOf(46)));
                return new FileInfo(FileType.TABLE, fileNumber);
            }
            if (fileName.endsWith(".dbtmp")) {
                long fileNumber = Filename.parseLong(Filename.removeSuffix(fileName, ".dbtmp"));
                return new FileInfo(FileType.TEMP, fileNumber);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long parseLong(String str) {
        return Long.parseUnsignedLong(str, 10);
    }

    public static void setCurrentFile(File databaseDir, long descriptorNumber, Env env) throws IOException {
        String manifest = Filename.descriptorFileName(descriptorNumber);
        String temp = Filename.tempFileName(descriptorNumber);
        File tempFile = databaseDir.child(temp);
        env.writeStringToFileSync(tempFile, manifest + "\n");
        File to = databaseDir.child(Filename.currentFileName());
        boolean ok = tempFile.renameTo(to);
        if (!ok) {
            tempFile.delete();
            env.writeStringToFileSync(to, manifest + "\n");
        }
    }

    public static String getCurrentFile(File databaseDir, Env env) throws IOException {
        File currentFile = databaseDir.child(Filename.currentFileName());
        Preconditions.checkState((boolean)currentFile.exists(), (Object)"CURRENT file does not exist");
        String descriptorName = env.readFileToString(currentFile);
        if (descriptorName.isEmpty() || descriptorName.charAt(descriptorName.length() - 1) != '\n') {
            throw new IllegalStateException("CURRENT file does not end with newline");
        }
        return descriptorName.substring(0, descriptorName.length() - 1);
    }

    private static String makeFileName(long number, String suffix) {
        Objects.requireNonNull(suffix, "suffix is null");
        return String.format("%s.%s", Strings.padStart((String)Long.toUnsignedString(number), (int)6, (char)'0'), suffix);
    }

    private static String removePrefix(String value, String prefix) {
        return value.substring(prefix.length());
    }

    private static String removeSuffix(String value, String suffix) {
        return value.substring(0, value.length() - suffix.length());
    }

    public static class FileInfo {
        private final FileType fileType;
        private final long fileNumber;

        public FileInfo(FileType fileType) {
            this(fileType, 0L);
        }

        public FileInfo(FileType fileType, long fileNumber) {
            Objects.requireNonNull(fileType, "fileType is null");
            this.fileType = fileType;
            this.fileNumber = fileNumber;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public long getFileNumber() {
            return this.fileNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileInfo fileInfo = (FileInfo)o;
            if (this.fileNumber != fileInfo.fileNumber) {
                return false;
            }
            return this.fileType == fileInfo.fileType;
        }

        public int hashCode() {
            int result = this.fileType.hashCode();
            result = 31 * result + (int)(this.fileNumber ^ this.fileNumber >>> 32);
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("FileInfo");
            sb.append("{fileType=").append((Object)this.fileType);
            sb.append(", fileNumber=").append(Long.toUnsignedString(this.fileNumber));
            sb.append('}');
            return sb.toString();
        }
    }

    public static enum FileType {
        LOG,
        DB_LOCK,
        TABLE,
        DESCRIPTOR,
        CURRENT,
        TEMP,
        INFO_LOG;

    }
}

