/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.fileenv;

import java.util.concurrent.atomic.AtomicInteger;

public final class MmapLimiter {
    public static final int CPU_DATA_MODEL;
    public static final boolean USE_MMAP;
    private AtomicInteger maxAllowedMmap;

    private MmapLimiter(int maxAllowedMmap) {
        this.maxAllowedMmap = new AtomicInteger(maxAllowedMmap);
    }

    public static MmapLimiter defaultLimiter() {
        return new MmapLimiter(USE_MMAP ? 1000 : 0);
    }

    public static MmapLimiter newLimiter(int maxAllowedMmap) {
        return new MmapLimiter(maxAllowedMmap);
    }

    public boolean acquire() {
        return this.maxAllowedMmap.getAndDecrement() > 0;
    }

    public void release() {
        this.maxAllowedMmap.incrementAndGet();
    }

    static {
        boolean is64bit = System.getProperty("os.name").contains("Windows") ? System.getenv("ProgramFiles(x86)") != null : System.getProperty("os.arch").contains("64");
        CPU_DATA_MODEL = is64bit ? 64 : 32;
        USE_MMAP = Boolean.parseBoolean(System.getProperty("leveldb.mmap", String.valueOf(CPU_DATA_MODEL > 32)));
    }
}

