/*
 * Decompiled with CFR 0.152.
 */
package io.github.patrick.gradle.remapper;

import java.io.Closeable;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.md_5.specialsource.Jar;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.JarRemapper;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JarProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001b\u001c\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0007R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\t0\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lio/github/patrick/gradle/remapper/RemapTask;", "Lorg/gradle/api/DefaultTask;", "()V", "action", "Lorg/gradle/api/provider/Property;", "Lio/github/patrick/gradle/remapper/RemapTask$Action;", "getAction", "()Lorg/gradle/api/provider/Property;", "archiveClassifier", "", "getArchiveClassifier", "archiveDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getArchiveDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "archiveName", "getArchiveName", "inputTask", "Lorg/gradle/api/tasks/bundling/AbstractArchiveTask;", "getInputTask", "skip", "", "getSkip", "version", "getVersion", "execute", "", "Action", "ActualProcedure", "Companion", "mojang-spigot-remapper"})
public abstract class RemapTask
extends DefaultTask {
    @NotNull
    private static final Companion Companion = new Companion(null);

    @Input
    @NotNull
    public abstract Property<String> getVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<Action> getAction();

    @Input
    @Optional
    @NotNull
    public abstract Property<Boolean> getSkip();

    @Input
    @Optional
    @NotNull
    public abstract Property<AbstractArchiveTask> getInputTask();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getArchiveClassifier();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getArchiveName();

    @InputDirectory
    @Optional
    @NotNull
    public abstract DirectoryProperty getArchiveDirectory();

    /*
     * WARNING - void declaration
     */
    @TaskAction
    public final void execute() {
        if (!Intrinsics.areEqual((Object)this.getSkip().getOrNull(), (Object)true)) {
            String string;
            AbstractArchiveTask abstractArchiveTask = (AbstractArchiveTask)this.getInputTask().getOrNull();
            if (abstractArchiveTask == null) {
                Object object = this.getProject().getTasks().named("jar").get();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.gradle.api.tasks.bundling.AbstractArchiveTask");
                abstractArchiveTask = (AbstractArchiveTask)object;
            }
            AbstractArchiveTask task = abstractArchiveTask;
            File archiveFile = ((RegularFile)task.getArchiveFile().get()).getAsFile();
            String string2 = (String)this.getVersion().getOrNull();
            if (string2 == null) {
                throw new IllegalStateException("Version should be specified for " + this.getProject().getPath() + '.');
            }
            String version = string2;
            Object object = (Directory)this.getArchiveDirectory().getOrNull();
            if (object == null || (object = object.getAsFile()) == null) {
                object = archiveFile.getParentFile();
            }
            if ((string = (String)this.getArchiveName().getOrNull()) == null) {
                String string3;
                String string4 = (String)this.getArchiveClassifier().getOrNull();
                if (string4 != null) {
                    void classifier;
                    String string5 = string4;
                    Object object2 = object;
                    boolean bl = false;
                    string3 = RemapTask.Companion.fileNameWithClassifier(task, (String)classifier);
                    object = object2;
                } else {
                    string3 = string = null;
                }
                if (string3 == null) {
                    string = archiveFile.getName();
                }
            }
            String string6 = string;
            Object object3 = object;
            File targetFile = new File((File)object3, string6);
            File fromFile = archiveFile;
            File toFile = Files.createTempFile(null, ".jar", new FileAttribute[0]).toFile();
            Action action = (Action)((Object)this.getAction().getOrElse((Object)Action.MOJANG_TO_SPIGOT));
            Iterator iterator = ArrayIteratorKt.iterator((Object[])action.getProcedures$mojang_spigot_remapper());
            boolean shouldRemove = false;
            while (iterator.hasNext()) {
                ActualProcedure procedure = (ActualProcedure)((Object)iterator.next());
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                File file = fromFile;
                Intrinsics.checkNotNull((Object)file);
                File file2 = file;
                file = toFile;
                Intrinsics.checkNotNull((Object)file);
                procedure.remap(project, version, file2, file);
                if (shouldRemove) {
                    fromFile.delete();
                }
                if (!iterator.hasNext()) continue;
                fromFile = toFile;
                toFile = Files.createTempFile(null, ".jar", new FileAttribute[0]).toFile();
                shouldRemove = true;
            }
            File file = toFile;
            Intrinsics.checkNotNull((Object)file);
            FilesKt.copyTo$default((File)file, (File)targetFile, (boolean)true, (int)0, (int)4, null);
            toFile.delete();
            System.out.println((Object)("Successfully obfuscate jar (" + this.getProject().getName() + ", " + (Object)((Object)action) + ')'));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u001e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/patrick/gradle/remapper/RemapTask$Action;", "", "procedures", "", "Lio/github/patrick/gradle/remapper/RemapTask$ActualProcedure;", "(Ljava/lang/String;I[Lio/github/patrick/gradle/remapper/RemapTask$ActualProcedure;)V", "getProcedures$mojang_spigot_remapper", "()[Lio/github/patrick/gradle/remapper/RemapTask$ActualProcedure;", "[Lio/github/patrick/gradle/remapper/RemapTask$ActualProcedure;", "MOJANG_TO_SPIGOT", "MOJANG_TO_OBF", "OBF_TO_MOJANG", "OBF_TO_SPIGOT", "SPIGOT_TO_MOJANG", "SPIGOT_TO_OBF", "mojang-spigot-remapper"})
    public static final class Action
    extends Enum<Action> {
        @NotNull
        private final ActualProcedure[] procedures;
        public static final /* enum */ Action MOJANG_TO_SPIGOT;
        public static final /* enum */ Action MOJANG_TO_OBF;
        public static final /* enum */ Action OBF_TO_MOJANG;
        public static final /* enum */ Action OBF_TO_SPIGOT;
        public static final /* enum */ Action SPIGOT_TO_MOJANG;
        public static final /* enum */ Action SPIGOT_TO_OBF;
        private static final /* synthetic */ Action[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Action(ActualProcedure ... procedures) {
            this.procedures = procedures;
        }

        @NotNull
        public final ActualProcedure[] getProcedures$mojang_spigot_remapper() {
            return this.procedures;
        }

        public static Action[] values() {
            return (Action[])$VALUES.clone();
        }

        public static Action valueOf(String value) {
            return Enum.valueOf(Action.class, value);
        }

        @NotNull
        public static EnumEntries<Action> getEntries() {
            return $ENTRIES;
        }

        static {
            ActualProcedure[] actualProcedureArray = new ActualProcedure[]{ActualProcedure.MOJANG_OBF, ActualProcedure.OBF_SPIGOT};
            MOJANG_TO_SPIGOT = new Action(actualProcedureArray);
            actualProcedureArray = new ActualProcedure[]{ActualProcedure.MOJANG_OBF};
            MOJANG_TO_OBF = new Action(actualProcedureArray);
            actualProcedureArray = new ActualProcedure[]{ActualProcedure.OBF_MOJANG};
            OBF_TO_MOJANG = new Action(actualProcedureArray);
            actualProcedureArray = new ActualProcedure[]{ActualProcedure.OBF_SPIGOT};
            OBF_TO_SPIGOT = new Action(actualProcedureArray);
            actualProcedureArray = new ActualProcedure[]{ActualProcedure.SPIGOT_OBF, ActualProcedure.OBF_MOJANG};
            SPIGOT_TO_MOJANG = new Action(actualProcedureArray);
            actualProcedureArray = new ActualProcedure[]{ActualProcedure.SPIGOT_OBF};
            SPIGOT_TO_OBF = new Action(actualProcedureArray);
            $VALUES = actionArray = new Action[]{Action.MOJANG_TO_SPIGOT, Action.MOJANG_TO_OBF, Action.OBF_TO_MOJANG, Action.OBF_TO_SPIGOT, Action.SPIGOT_TO_MOJANG, Action.SPIGOT_TO_OBF};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001BW\b\u0002\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ&\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011R)\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lio/github/patrick/gradle/remapper/RemapTask$ActualProcedure;", "", "mapping", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "version", "inheritance", "reversed", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Z)V", "remap", "", "project", "Lorg/gradle/api/Project;", "jarFile", "Ljava/io/File;", "outputFile", "MOJANG_OBF", "OBF_MOJANG", "SPIGOT_OBF", "OBF_SPIGOT", "mojang-spigot-remapper"})
    public static final class ActualProcedure
    extends Enum<ActualProcedure> {
        @NotNull
        private final Function1<String, String> mapping;
        @NotNull
        private final Function1<String, String> inheritance;
        private final boolean reversed;
        public static final /* enum */ ActualProcedure MOJANG_OBF = new ActualProcedure((Function1<? super String, String>)((Function1)1.INSTANCE), (Function1<? super String, String>)((Function1)2.INSTANCE), true);
        public static final /* enum */ ActualProcedure OBF_MOJANG = new ActualProcedure("OBF_MOJANG", 1, 3.INSTANCE, 4.INSTANCE, false, 4, null);
        public static final /* enum */ ActualProcedure SPIGOT_OBF = new ActualProcedure((Function1<? super String, String>)((Function1)5.INSTANCE), (Function1<? super String, String>)((Function1)6.INSTANCE), true);
        public static final /* enum */ ActualProcedure OBF_SPIGOT = new ActualProcedure("OBF_SPIGOT", 3, 7.INSTANCE, 8.INSTANCE, false, 4, null);
        private static final /* synthetic */ ActualProcedure[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private ActualProcedure(Function1<? super String, String> mapping, Function1<? super String, String> inheritance, boolean reversed) {
            this.mapping = mapping;
            this.inheritance = inheritance;
            this.reversed = reversed;
        }

        /* synthetic */ ActualProcedure(String string, int n, Function1 function1, Function1 function12, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this((Function1<? super String, String>)function1, (Function1<? super String, String>)function12, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void remap(@NotNull Project project, @NotNull String version, @NotNull File jarFile, @NotNull File outputFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
            Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
            DependencyHandler dependencies = project.getDependencies();
            Dependency[] dependencyArray = new Dependency[]{dependencies.create(this.mapping.invoke((Object)version))};
            File mappingFile = project.getConfigurations().detachedConfiguration(dependencyArray).getSingleFile();
            Object object = new Configuration[]{dependencies.create(this.inheritance.invoke((Object)version))};
            Configuration $this$remap_u24lambda_u240 = object = project.getConfigurations().detachedConfiguration((Dependency[])object);
            boolean bl = false;
            $this$remap_u24lambda_u240.setTransitive(false);
            File inheritanceFile = object.getSingleFile();
            object = (Closeable)Jar.init((File)jarFile);
            Throwable throwable = null;
            try {
                Jar inputJar = (Jar)object;
                boolean bl2 = false;
                Closeable closeable = (Closeable)Jar.init((File)inheritanceFile);
                Throwable throwable2 = null;
                try {
                    Jar inheritanceJar = (Jar)closeable;
                    boolean bl3 = false;
                    JarMapping mapping = new JarMapping();
                    mapping.loadMappings(mappingFile.getCanonicalPath(), this.reversed, false, null, null);
                    JointProvider provider = new JointProvider();
                    provider.add((InheritanceProvider)new JarProvider(inputJar));
                    provider.add((InheritanceProvider)new JarProvider(inheritanceJar));
                    mapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
                    JarRemapper mapper = new JarRemapper(mapping);
                    mapper.remapJar(inputJar, outputFile);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }

        public static ActualProcedure[] values() {
            return (ActualProcedure[])$VALUES.clone();
        }

        public static ActualProcedure valueOf(String value) {
            return Enum.valueOf(ActualProcedure.class, value);
        }

        @NotNull
        public static EnumEntries<ActualProcedure> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = actualProcedureArray = new ActualProcedure[]{ActualProcedure.MOJANG_OBF, ActualProcedure.OBF_MOJANG, ActualProcedure.SPIGOT_OBF, ActualProcedure.OBF_SPIGOT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"Lio/github/patrick/gradle/remapper/RemapTask$Companion;", "", "()V", "fileNameWithClassifier", "", "Lorg/gradle/api/tasks/bundling/AbstractArchiveTask;", "classifier", "mojang-spigot-remapper"})
    private static final class Companion {
        private Companion() {
        }

        private final String fileNameWithClassifier(AbstractArchiveTask $this$fileNameWithClassifier, String classifier) {
            return (String)$this$fileNameWithClassifier.getArchiveBaseName().get() + '-' + (String)$this$fileNameWithClassifier.getArchiveVersion().get() + '-' + classifier + ".jar";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

