(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kotlin-logging-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kotlin-logging-js-legacy'.");
    }
    root['kotlin-logging-js-legacy'] = factory(typeof this['kotlin-logging-js-legacy'] === 'undefined' ? {} : this['kotlin-logging-js-legacy'], kotlin);
  }
}(this, function (_, Kotlin) {
  'use strict';
  var Kind_INTERFACE = Kotlin.Kind.INTERFACE;
  var Unit = Kotlin.kotlin.Unit;
  var joinToString = Kotlin.kotlin.collections.joinToString_cgipc5$;
  var Throwable = Error;
  var throwCCE = Kotlin.throwCCE;
  var NotImplementedError_init = Kotlin.kotlin.NotImplementedError;
  var Kind_CLASS = Kotlin.Kind.CLASS;
  var Kind_OBJECT = Kotlin.Kind.OBJECT;
  var Enum = Kotlin.kotlin.Enum;
  var throwISE = Kotlin.throwISE;
  var IllegalArgumentException_init = Kotlin.kotlin.IllegalArgumentException_init_pdl1vj$;
  var toString = Kotlin.toString;
  var Exception = Kotlin.kotlin.Exception;
  var equals = Kotlin.equals;
  var StringBuilder_init = Kotlin.kotlin.text.StringBuilder_init;
  var throwUPAE = Kotlin.throwUPAE;
  var ReadOnlyProperty = Kotlin.kotlin.properties.ReadOnlyProperty;
  var Exception_init = Kotlin.kotlin.Exception_init;
  var stackTraceToString = Kotlin.kotlin.stackTraceToString_dbl4o4$;
  var split = Kotlin.kotlin.text.split_ip8yn$;
  var substringBefore = Kotlin.kotlin.text.substringBefore_j4ogox$;
  var substringAfterLast = Kotlin.kotlin.text.substringAfterLast_j4ogox$;
  var contains = Kotlin.kotlin.text.contains_li3zpu$;
  Level.prototype = Object.create(Enum.prototype);
  Level.prototype.constructor = Level;
  ConsoleOutputAppender.prototype = Object.create(FormattingAppender.prototype);
  ConsoleOutputAppender.prototype.constructor = ConsoleOutputAppender;
  function DelegatingKLogger() {
  }
  DelegatingKLogger.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'DelegatingKLogger',
    interfaces: []
  };
  function KLogger() {
  }
  function KLogger$trace$lambda(closure$message) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      return Unit;
    };
  }
  KLogger.prototype.trace_nq59yw$ = function (message) {
    this.at_oj83f8$(Level$TRACE_getInstance(), void 0, KLogger$trace$lambda(message));
  };
  function KLogger$debug$lambda(closure$message) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      return Unit;
    };
  }
  KLogger.prototype.debug_nq59yw$ = function (message) {
    this.at_oj83f8$(Level$DEBUG_getInstance(), void 0, KLogger$debug$lambda(message));
  };
  function KLogger$info$lambda(closure$message) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      return Unit;
    };
  }
  KLogger.prototype.info_nq59yw$ = function (message) {
    this.at_oj83f8$(Level$INFO_getInstance(), void 0, KLogger$info$lambda(message));
  };
  function KLogger$warn$lambda(closure$message) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      return Unit;
    };
  }
  KLogger.prototype.warn_nq59yw$ = function (message) {
    this.at_oj83f8$(Level$WARN_getInstance(), void 0, KLogger$warn$lambda(message));
  };
  function KLogger$error$lambda(closure$message) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      return Unit;
    };
  }
  KLogger.prototype.error_nq59yw$ = function (message) {
    this.at_oj83f8$(Level$ERROR_getInstance(), void 0, KLogger$error$lambda(message));
  };
  function KLogger$trace$lambda_0(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.trace_ca4k3s$ = function (throwable, message) {
    this.at_oj83f8$(Level$TRACE_getInstance(), void 0, KLogger$trace$lambda_0(message, throwable));
  };
  function KLogger$debug$lambda_0(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.debug_ca4k3s$ = function (throwable, message) {
    this.at_oj83f8$(Level$DEBUG_getInstance(), void 0, KLogger$debug$lambda_0(message, throwable));
  };
  function KLogger$info$lambda_0(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.info_ca4k3s$ = function (throwable, message) {
    this.at_oj83f8$(Level$INFO_getInstance(), void 0, KLogger$info$lambda_0(message, throwable));
  };
  function KLogger$warn$lambda_0(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.warn_ca4k3s$ = function (throwable, message) {
    this.at_oj83f8$(Level$WARN_getInstance(), void 0, KLogger$warn$lambda_0(message, throwable));
  };
  function KLogger$error$lambda_0(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.error_ca4k3s$ = function (throwable, message) {
    this.at_oj83f8$(Level$ERROR_getInstance(), void 0, KLogger$error$lambda_0(message, throwable));
  };
  function KLogger$trace$lambda_1(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.trace_16r1tg$ = function (throwable, marker, message) {
    this.at_oj83f8$(Level$TRACE_getInstance(), marker, KLogger$trace$lambda_1(message, throwable));
  };
  function KLogger$debug$lambda_1(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.debug_16r1tg$ = function (throwable, marker, message) {
    this.at_oj83f8$(Level$DEBUG_getInstance(), marker, KLogger$debug$lambda_1(message, throwable));
  };
  function KLogger$info$lambda_1(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.info_16r1tg$ = function (throwable, marker, message) {
    this.at_oj83f8$(Level$INFO_getInstance(), marker, KLogger$info$lambda_1(message, throwable));
  };
  function KLogger$warn$lambda_1(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.warn_16r1tg$ = function (throwable, marker, message) {
    this.at_oj83f8$(Level$WARN_getInstance(), marker, KLogger$warn$lambda_1(message, throwable));
  };
  function KLogger$error$lambda_1(closure$message, closure$throwable) {
    return function ($receiver) {
      $receiver.message = toStringSafe(closure$message);
      $receiver.cause = closure$throwable;
      return Unit;
    };
  }
  KLogger.prototype.error_16r1tg$ = function (throwable, marker, message) {
    this.at_oj83f8$(Level$ERROR_getInstance(), marker, KLogger$error$lambda_1(message, throwable));
  };
  KLogger.prototype.atTrace_svfspb$$default = function (marker, block) {
    this.at_oj83f8$(Level$TRACE_getInstance(), marker, block);
  };
  KLogger.prototype.atTrace_svfspb$ = function (marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(marker, block) : this.atTrace_svfspb$$default(marker, block);
  };
  KLogger.prototype.atDebug_svfspb$$default = function (marker, block) {
    this.at_oj83f8$(Level$DEBUG_getInstance(), marker, block);
  };
  KLogger.prototype.atDebug_svfspb$ = function (marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(marker, block) : this.atDebug_svfspb$$default(marker, block);
  };
  KLogger.prototype.atInfo_svfspb$$default = function (marker, block) {
    this.at_oj83f8$(Level$INFO_getInstance(), marker, block);
  };
  KLogger.prototype.atInfo_svfspb$ = function (marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(marker, block) : this.atInfo_svfspb$$default(marker, block);
  };
  KLogger.prototype.atWarn_svfspb$$default = function (marker, block) {
    this.at_oj83f8$(Level$WARN_getInstance(), marker, block);
  };
  KLogger.prototype.atWarn_svfspb$ = function (marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(marker, block) : this.atWarn_svfspb$$default(marker, block);
  };
  KLogger.prototype.atError_svfspb$$default = function (marker, block) {
    this.at_oj83f8$(Level$ERROR_getInstance(), marker, block);
  };
  KLogger.prototype.atError_svfspb$ = function (marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(marker, block) : this.atError_svfspb$$default(marker, block);
  };
  KLogger.prototype.at_oj83f8$ = function (level, marker, block, callback$default) {
    if (marker === void 0)
      marker = null;
    callback$default ? callback$default(level, marker, block) : this.at_oj83f8$$default(level, marker, block);
  };
  function KLogger$entry$lambda(closure$arguments) {
    return function () {
      return 'entry(' + joinToString(closure$arguments) + ')';
    };
  }
  KLogger.prototype.entry_yhszz7$ = function (arguments_0) {
    this.trace_nq59yw$(KLogger$entry$lambda(arguments_0));
  };
  function KLogger$exit$lambda() {
    return 'exit';
  }
  KLogger.prototype.exit = function () {
    this.trace_nq59yw$(KLogger$exit$lambda);
  };
  function KLogger$exit$lambda_0(closure$result) {
    return function () {
      return 'exit(' + closure$result + ')';
    };
  }
  KLogger.prototype.exit_mh5how$ = function (result) {
    this.trace_nq59yw$(KLogger$exit$lambda_0(result));
    return result;
  };
  function KLogger$throwing$lambda(closure$throwable) {
    return function ($receiver) {
      $receiver.cause = closure$throwable;
      $receiver.message = 'throwing(' + closure$throwable + ')';
      return Unit;
    };
  }
  KLogger.prototype.throwing_849n7l$ = function (throwable) {
    this.atError_svfspb$(void 0, KLogger$throwing$lambda(throwable));
    return throwable;
  };
  function KLogger$catching$lambda(closure$throwable) {
    return function ($receiver) {
      $receiver.cause = closure$throwable;
      $receiver.message = 'catching(' + closure$throwable + ')';
      return Unit;
    };
  }
  KLogger.prototype.catching_849n7l$ = function (throwable) {
    this.atError_svfspb$(void 0, KLogger$catching$lambda(throwable));
  };
  KLogger.prototype.isTraceEnabled_77d0nk$$default = function (marker) {
    return this.isLoggingEnabledFor_29zy0j$(Level$TRACE_getInstance(), marker);
  };
  KLogger.prototype.isTraceEnabled_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isTraceEnabled_77d0nk$$default(marker);
  };
  KLogger.prototype.isDebugEnabled_77d0nk$$default = function (marker) {
    return this.isLoggingEnabledFor_29zy0j$(Level$DEBUG_getInstance(), marker);
  };
  KLogger.prototype.isDebugEnabled_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isDebugEnabled_77d0nk$$default(marker);
  };
  KLogger.prototype.isInfoEnabled_77d0nk$$default = function (marker) {
    return this.isLoggingEnabledFor_29zy0j$(Level$INFO_getInstance(), marker);
  };
  KLogger.prototype.isInfoEnabled_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isInfoEnabled_77d0nk$$default(marker);
  };
  KLogger.prototype.isWarnEnabled_77d0nk$$default = function (marker) {
    return this.isLoggingEnabledFor_29zy0j$(Level$WARN_getInstance(), marker);
  };
  KLogger.prototype.isWarnEnabled_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isWarnEnabled_77d0nk$$default(marker);
  };
  KLogger.prototype.isErrorEnabled_77d0nk$$default = function (marker) {
    return this.isLoggingEnabledFor_29zy0j$(Level$ERROR_getInstance(), marker);
  };
  KLogger.prototype.isErrorEnabled_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isErrorEnabled_77d0nk$$default(marker);
  };
  KLogger.prototype.isLoggingOff_77d0nk$$default = function (marker) {
    return !this.isLoggingEnabledFor_29zy0j$(Level$ERROR_getInstance(), marker);
  };
  KLogger.prototype.isLoggingOff_77d0nk$ = function (marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(marker) : this.isLoggingOff_77d0nk$$default(marker);
  };
  KLogger.prototype.isLoggingEnabledFor_29zy0j$ = function (level, marker, callback$default) {
    if (marker === void 0)
      marker = null;
    return callback$default ? callback$default(level, marker) : this.isLoggingEnabledFor_29zy0j$$default(level, marker);
  };
  KLogger.prototype.trace_unuu8c$ = function (marker, msg) {
    var tmp$;
    this.trace_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, msg);
  };
  KLogger.prototype.debug_unuu8c$ = function (marker, msg) {
    var tmp$;
    this.debug_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, msg);
  };
  KLogger.prototype.info_unuu8c$ = function (marker, msg) {
    var tmp$;
    this.info_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, msg);
  };
  KLogger.prototype.warn_unuu8c$ = function (marker, msg) {
    var tmp$;
    this.warn_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, msg);
  };
  KLogger.prototype.error_unuu8c$ = function (marker, msg) {
    var tmp$;
    this.error_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, msg);
  };
  KLogger.prototype.trace_o7l9n0$ = function (marker, t, msg) {
    this.trace_16r1tg$(t, marker, msg);
  };
  KLogger.prototype.debug_o7l9n0$ = function (marker, t, msg) {
    this.debug_16r1tg$(t, marker, msg);
  };
  KLogger.prototype.info_o7l9n0$ = function (marker, t, msg) {
    this.info_16r1tg$(t, marker, msg);
  };
  KLogger.prototype.warn_o7l9n0$ = function (marker, t, msg) {
    this.warn_16r1tg$(t, marker, msg);
  };
  KLogger.prototype.error_o7l9n0$ = function (marker, t, msg) {
    this.error_16r1tg$(t, marker, msg);
  };
  Object.defineProperty(KLogger.prototype, 'isTraceEnabled', {
    configurable: true,
    get: function () {
      return this.isTraceEnabled_77d0nk$();
    }
  });
  Object.defineProperty(KLogger.prototype, 'isDebugEnabled', {
    configurable: true,
    get: function () {
      return this.isDebugEnabled_77d0nk$();
    }
  });
  Object.defineProperty(KLogger.prototype, 'isInfoEnabled', {
    configurable: true,
    get: function () {
      return this.isInfoEnabled_77d0nk$();
    }
  });
  Object.defineProperty(KLogger.prototype, 'isWarnEnabled', {
    configurable: true,
    get: function () {
      return this.isWarnEnabled_77d0nk$();
    }
  });
  Object.defineProperty(KLogger.prototype, 'isErrorEnabled', {
    configurable: true,
    get: function () {
      return this.isErrorEnabled_77d0nk$();
    }
  });
  Object.defineProperty(KLogger.prototype, 'isLoggingOff', {
    configurable: true,
    get: function () {
      return this.isLoggingOff_77d0nk$();
    }
  });
  function KLogger$trace$lambda_2(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.trace_pdl1vj$ = function (msg) {
    this.trace_nq59yw$(KLogger$trace$lambda_2(msg));
  };
  KLogger.prototype.trace_67rc9h$ = function (msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.trace_lzc6tz$ = function (msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.trace_c7dlu0$ = function (msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$trace$lambda_3(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.trace_wspj0f$ = function (msg, t) {
    var tmp$;
    this.trace_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), null, KLogger$trace$lambda_3(msg));
  };
  function KLogger$trace$lambda_4(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.trace_9i0b99$ = function (marker, msg) {
    var tmp$;
    this.trace_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, KLogger$trace$lambda_4(msg));
  };
  KLogger.prototype.trace_hh0jo1$ = function (marker, msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.trace_z116hx$ = function (marker, msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.trace_qha0wc$ = function (marker, msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$trace$lambda_5(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.trace_lux9z7$ = function (marker, msg, t) {
    var tmp$;
    this.trace_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), marker, KLogger$trace$lambda_5(msg));
  };
  function KLogger$debug$lambda_2(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.debug_pdl1vj$ = function (msg) {
    this.debug_nq59yw$(KLogger$debug$lambda_2(msg));
  };
  KLogger.prototype.debug_67rc9h$ = function (msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.debug_lzc6tz$ = function (msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.debug_c7dlu0$ = function (msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$debug$lambda_3(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.debug_wspj0f$ = function (msg, t) {
    var tmp$;
    this.debug_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), null, KLogger$debug$lambda_3(msg));
  };
  function KLogger$debug$lambda_4(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.debug_9i0b99$ = function (marker, msg) {
    var tmp$;
    this.debug_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, KLogger$debug$lambda_4(msg));
  };
  KLogger.prototype.debug_hh0jo1$ = function (marker, msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.debug_z116hx$ = function (marker, msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.debug_qha0wc$ = function (marker, msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$debug$lambda_5(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.debug_lux9z7$ = function (marker, msg, t) {
    var tmp$;
    this.debug_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), marker, KLogger$debug$lambda_5(msg));
  };
  function KLogger$info$lambda_2(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.info_pdl1vj$ = function (msg) {
    this.info_nq59yw$(KLogger$info$lambda_2(msg));
  };
  KLogger.prototype.info_67rc9h$ = function (msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.info_lzc6tz$ = function (msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.info_c7dlu0$ = function (msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$info$lambda_3(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.info_wspj0f$ = function (msg, t) {
    var tmp$;
    this.info_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), null, KLogger$info$lambda_3(msg));
  };
  function KLogger$info$lambda_4(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.info_9i0b99$ = function (marker, msg) {
    var tmp$;
    this.info_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, KLogger$info$lambda_4(msg));
  };
  KLogger.prototype.info_hh0jo1$ = function (marker, msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.info_z116hx$ = function (marker, msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.info_qha0wc$ = function (marker, msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$info$lambda_5(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.info_lux9z7$ = function (marker, msg, t) {
    var tmp$;
    this.info_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), marker, KLogger$info$lambda_5(msg));
  };
  function KLogger$warn$lambda_2(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.warn_pdl1vj$ = function (msg) {
    this.warn_nq59yw$(KLogger$warn$lambda_2(msg));
  };
  KLogger.prototype.warn_67rc9h$ = function (msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.warn_c7dlu0$ = function (msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.warn_lzc6tz$ = function (msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  function KLogger$warn$lambda_3(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.warn_wspj0f$ = function (msg, t) {
    var tmp$;
    this.warn_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), null, KLogger$warn$lambda_3(msg));
  };
  function KLogger$warn$lambda_4(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.warn_9i0b99$ = function (marker, msg) {
    var tmp$;
    this.warn_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, KLogger$warn$lambda_4(msg));
  };
  KLogger.prototype.warn_hh0jo1$ = function (marker, msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.warn_z116hx$ = function (marker, msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.warn_qha0wc$ = function (marker, msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$warn$lambda_5(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.warn_lux9z7$ = function (marker, msg, t) {
    var tmp$;
    this.warn_16r1tg$(Kotlin.isType(tmp$ = t, Throwable) ? tmp$ : throwCCE(), marker, KLogger$warn$lambda_5(msg));
  };
  function KLogger$error$lambda_2(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.error_pdl1vj$ = function (msg) {
    this.error_nq59yw$(KLogger$error$lambda_2(msg));
  };
  KLogger.prototype.error_67rc9h$ = function (msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.error_lzc6tz$ = function (msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.error_c7dlu0$ = function (msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$error$lambda_3(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.error_wspj0f$ = function (msg, t) {
    this.error_16r1tg$(t, null, KLogger$error$lambda_3(msg));
  };
  function KLogger$error$lambda_4(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.error_9i0b99$ = function (marker, msg) {
    var tmp$;
    this.error_16r1tg$((tmp$ = null) == null || Kotlin.isType(tmp$, Throwable) ? tmp$ : throwCCE(), marker, KLogger$error$lambda_4(msg));
  };
  KLogger.prototype.error_hh0jo1$ = function (marker, msg, arg) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.error_z116hx$ = function (marker, msg, arg1, arg2) {
    throw new NotImplementedError_init();
  };
  KLogger.prototype.error_qha0wc$ = function (marker, msg, arguments_0) {
    throw new NotImplementedError_init();
  };
  function KLogger$error$lambda_5(closure$msg) {
    return function () {
      return closure$msg;
    };
  }
  KLogger.prototype.error_lux9z7$ = function (marker, msg, t) {
    this.error_16r1tg$(t, marker, KLogger$error$lambda_5(msg));
  };
  KLogger.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'KLogger',
    interfaces: []
  };
  function KLoggingEventBuilder() {
    this.message = null;
    this.cause = null;
    this.payload = null;
  }
  KLoggingEventBuilder.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLoggingEventBuilder',
    interfaces: []
  };
  function KMarkerFactory() {
    KMarkerFactory_instance = this;
  }
  KMarkerFactory.prototype.getMarker_61zpoe$ = function (name) {
    return new SimpleMarker(name);
  };
  KMarkerFactory.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KMarkerFactory',
    interfaces: []
  };
  var KMarkerFactory_instance = null;
  function KMarkerFactory_getInstance() {
    if (KMarkerFactory_instance === null) {
      new KMarkerFactory();
    }
    return KMarkerFactory_instance;
  }
  function KotlinLogging() {
    KotlinLogging_instance = this;
  }
  KotlinLogging.prototype.logger_o14v8n$ = function (func) {
    return this.logger_61zpoe$(KLoggerNameResolver_getInstance().name_ls4sck$(func));
  };
  KotlinLogging.prototype.logger_61zpoe$ = function (name) {
    return KLoggerFactory_getInstance().logger_61zpoe$(name);
  };
  KotlinLogging.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinLogging',
    interfaces: []
  };
  var KotlinLogging_instance = null;
  function KotlinLogging_getInstance() {
    if (KotlinLogging_instance === null) {
      new KotlinLogging();
    }
    return KotlinLogging_instance;
  }
  function Level(name, ordinal, levelInt, levelStr) {
    Enum.call(this);
    this.levelInt_mv380$_0 = levelInt;
    this.levelStr_n1lhq$_0 = levelStr;
    this.name$ = name;
    this.ordinal$ = ordinal;
  }
  function Level_initFields() {
    Level_initFields = function () {
    };
    Level$TRACE_instance = new Level('TRACE', 0, 0, 'TRACE');
    Level$DEBUG_instance = new Level('DEBUG', 1, 10, 'DEBUG');
    Level$INFO_instance = new Level('INFO', 2, 20, 'INFO');
    Level$WARN_instance = new Level('WARN', 3, 30, 'WARN');
    Level$ERROR_instance = new Level('ERROR', 4, 40, 'ERROR');
    Level$OFF_instance = new Level('OFF', 5, 50, 'OFF');
  }
  var Level$TRACE_instance;
  function Level$TRACE_getInstance() {
    Level_initFields();
    return Level$TRACE_instance;
  }
  var Level$DEBUG_instance;
  function Level$DEBUG_getInstance() {
    Level_initFields();
    return Level$DEBUG_instance;
  }
  var Level$INFO_instance;
  function Level$INFO_getInstance() {
    Level_initFields();
    return Level$INFO_instance;
  }
  var Level$WARN_instance;
  function Level$WARN_getInstance() {
    Level_initFields();
    return Level$WARN_instance;
  }
  var Level$ERROR_instance;
  function Level$ERROR_getInstance() {
    Level_initFields();
    return Level$ERROR_instance;
  }
  var Level$OFF_instance;
  function Level$OFF_getInstance() {
    Level_initFields();
    return Level$OFF_instance;
  }
  Level.prototype.toInt = function () {
    return this.levelInt_mv380$_0;
  };
  Level.prototype.toString = function () {
    return this.levelStr_n1lhq$_0;
  };
  Level.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'Level',
    interfaces: [Enum]
  };
  function Level$values() {
    return [Level$TRACE_getInstance(), Level$DEBUG_getInstance(), Level$INFO_getInstance(), Level$WARN_getInstance(), Level$ERROR_getInstance(), Level$OFF_getInstance()];
  }
  Level.values = Level$values;
  function Level$valueOf(name) {
    switch (name) {
      case 'TRACE':
        return Level$TRACE_getInstance();
      case 'DEBUG':
        return Level$DEBUG_getInstance();
      case 'INFO':
        return Level$INFO_getInstance();
      case 'WARN':
        return Level$WARN_getInstance();
      case 'ERROR':
        return Level$ERROR_getInstance();
      case 'OFF':
        return Level$OFF_getInstance();
      default:
        throwISE('No enum constant io.github.oshai.kotlinlogging.Level.' + name);
    }
  }
  Level.valueOf_61zpoe$ = Level$valueOf;
  function Levels() {
    Levels_instance = this;
    this.TRACE_INT = 0;
    this.DEBUG_INT = 10;
    this.INFO_INT = 20;
    this.WARN_INT = 30;
    this.ERROR_INT = 40;
    this.OFF_INT = 50;
  }
  Levels.prototype.intToLevel_za3lpa$ = function (levelInt) {
    var tmp$;
    switch (levelInt) {
      case 0:
        tmp$ = Level$TRACE_getInstance();
        break;
      case 10:
        tmp$ = Level$DEBUG_getInstance();
        break;
      case 20:
        tmp$ = Level$INFO_getInstance();
        break;
      case 30:
        tmp$ = Level$WARN_getInstance();
        break;
      case 40:
        tmp$ = Level$ERROR_getInstance();
        break;
      case 50:
        tmp$ = Level$OFF_getInstance();
        break;
      default:
        throw IllegalArgumentException_init('Level integer [' + levelInt + '] not recognized.');
    }
    return tmp$;
  };
  Levels.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'Levels',
    interfaces: []
  };
  var Levels_instance = null;
  function Levels_getInstance() {
    if (Levels_instance === null) {
      new Levels();
    }
    return Levels_instance;
  }
  function Marker() {
  }
  Marker.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Marker',
    interfaces: []
  };
  function SimpleMarker(name) {
    this.name_0 = name;
  }
  SimpleMarker.prototype.getName = function () {
    return this.name_0;
  };
  SimpleMarker.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'SimpleMarker',
    interfaces: [Marker]
  };
  SimpleMarker.prototype.component1_0 = function () {
    return this.name_0;
  };
  SimpleMarker.prototype.copy_61zpoe$ = function (name) {
    return new SimpleMarker(name === void 0 ? this.name_0 : name);
  };
  SimpleMarker.prototype.toString = function () {
    return 'SimpleMarker(name=' + Kotlin.toString(this.name_0) + ')';
  };
  SimpleMarker.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.name_0) | 0;
    return result;
  };
  SimpleMarker.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && Kotlin.equals(this.name_0, other.name_0))));
  };
  function toStringSafe($receiver) {
    var tmp$;
    try {
      tmp$ = toString($receiver());
    } catch (e) {
      if (Kotlin.isType(e, Exception)) {
        tmp$ = DefaultErrorMessageProducer_getInstance().getErrorLog_3lhtaa$(e);
      } else
        throw e;
    }
    return tmp$;
  }
  function DefaultErrorMessageProducer() {
    DefaultErrorMessageProducer_instance = this;
  }
  DefaultErrorMessageProducer.prototype.getErrorLog_3lhtaa$ = function (e) {
    return 'Log message invocation failed: ' + e;
  };
  DefaultErrorMessageProducer.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'DefaultErrorMessageProducer',
    interfaces: []
  };
  var DefaultErrorMessageProducer_instance = null;
  function DefaultErrorMessageProducer_getInstance() {
    if (DefaultErrorMessageProducer_instance === null) {
      new DefaultErrorMessageProducer();
    }
    return DefaultErrorMessageProducer_instance;
  }
  function Appender() {
  }
  Appender.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Appender',
    interfaces: []
  };
  function FormattingAppender() {
  }
  FormattingAppender.prototype.log_yeoadr$ = function (loggingEvent) {
    this.logFormattedMessage_wwvt2z$(loggingEvent, KotlinLoggingConfiguration_getInstance().formatter.formatMessage_yeoadr$(loggingEvent));
  };
  FormattingAppender.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'FormattingAppender',
    interfaces: [Appender]
  };
  function Formatter() {
  }
  Formatter.$metadata$ = {
    kind: Kind_INTERFACE,
    simpleName: 'Formatter',
    interfaces: []
  };
  function DefaultMessageFormatter(includePrefix) {
    if (includePrefix === void 0)
      includePrefix = true;
    this.includePrefix_0 = includePrefix;
  }
  DefaultMessageFormatter.prototype.formatMessage_yeoadr$ = function (loggingEvent) {
    var $receiver = StringBuilder_init();
    var tmp$, tmp$_0;
    $receiver.append_pdl1vj$(this.prefix_0(loggingEvent.level, loggingEvent.loggerName));
    if ((tmp$_0 = (tmp$ = loggingEvent.marker) != null ? tmp$.getName() : null) != null) {
      $receiver.append_pdl1vj$(tmp$_0);
      $receiver.append_pdl1vj$(' ');
    }
    $receiver.append_pdl1vj$(loggingEvent.message);
    $receiver.append_pdl1vj$(this.throwableToString_0(loggingEvent.cause));
    return $receiver.toString();
  };
  DefaultMessageFormatter.prototype.prefix_0 = function (level, loggerName) {
    var tmp$;
    if (this.includePrefix_0) {
      tmp$ = level.name + ': [' + loggerName + '] ';
    } else {
      tmp$ = '';
    }
    return tmp$;
  };
  DefaultMessageFormatter.prototype.throwableToString_0 = function ($receiver) {
    if ($receiver == null) {
      return '';
    }
    var msg = '';
    var current = $receiver;
    while (current != null && !equals(current.cause, current)) {
      msg += ", Caused by: '" + toString(current.message) + "'";
      current = current.cause;
    }
    return msg;
  };
  DefaultMessageFormatter.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'DefaultMessageFormatter',
    interfaces: [Formatter]
  };
  function KLoggingEvent(level, marker, loggerName, message, cause, payload) {
    if (message === void 0)
      message = null;
    if (cause === void 0)
      cause = null;
    if (payload === void 0)
      payload = null;
    this.level = level;
    this.marker = marker;
    this.loggerName = loggerName;
    this.message = message;
    this.cause = cause;
    this.payload = payload;
  }
  KLoggingEvent.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLoggingEvent',
    interfaces: []
  };
  function KLoggingEvent_init(level, marker, loggerName, eventBuilder, $this) {
    $this = $this || Object.create(KLoggingEvent.prototype);
    KLoggingEvent.call($this, level, marker, loggerName, eventBuilder.message, eventBuilder.cause, eventBuilder.payload);
    return $this;
  }
  KLoggingEvent.prototype.component1 = function () {
    return this.level;
  };
  KLoggingEvent.prototype.component2 = function () {
    return this.marker;
  };
  KLoggingEvent.prototype.component3 = function () {
    return this.loggerName;
  };
  KLoggingEvent.prototype.component4 = function () {
    return this.message;
  };
  KLoggingEvent.prototype.component5 = function () {
    return this.cause;
  };
  KLoggingEvent.prototype.component6 = function () {
    return this.payload;
  };
  KLoggingEvent.prototype.copy_i5a0or$ = function (level, marker, loggerName, message, cause, payload) {
    return new KLoggingEvent(level === void 0 ? this.level : level, marker === void 0 ? this.marker : marker, loggerName === void 0 ? this.loggerName : loggerName, message === void 0 ? this.message : message, cause === void 0 ? this.cause : cause, payload === void 0 ? this.payload : payload);
  };
  KLoggingEvent.prototype.toString = function () {
    return 'KLoggingEvent(level=' + Kotlin.toString(this.level) + (', marker=' + Kotlin.toString(this.marker)) + (', loggerName=' + Kotlin.toString(this.loggerName)) + (', message=' + Kotlin.toString(this.message)) + (', cause=' + Kotlin.toString(this.cause)) + (', payload=' + Kotlin.toString(this.payload)) + ')';
  };
  KLoggingEvent.prototype.hashCode = function () {
    var result = 0;
    result = result * 31 + Kotlin.hashCode(this.level) | 0;
    result = result * 31 + Kotlin.hashCode(this.marker) | 0;
    result = result * 31 + Kotlin.hashCode(this.loggerName) | 0;
    result = result * 31 + Kotlin.hashCode(this.message) | 0;
    result = result * 31 + Kotlin.hashCode(this.cause) | 0;
    result = result * 31 + Kotlin.hashCode(this.payload) | 0;
    return result;
  };
  KLoggingEvent.prototype.equals = function (other) {
    return this === other || (other !== null && (typeof other === 'object' && (Object.getPrototypeOf(this) === Object.getPrototypeOf(other) && (Kotlin.equals(this.level, other.level) && Kotlin.equals(this.marker, other.marker) && Kotlin.equals(this.loggerName, other.loggerName) && Kotlin.equals(this.message, other.message) && Kotlin.equals(this.cause, other.cause) && Kotlin.equals(this.payload, other.payload)))));
  };
  function isLoggingEnabled($receiver) {
    return $receiver.ordinal >= KotlinLoggingConfiguration_getInstance().logLevel.ordinal;
  }
  function KLoggerDirect(name) {
    this.name_ny8e0n$_0 = name;
  }
  Object.defineProperty(KLoggerDirect.prototype, 'name', {
    get: function () {
      return this.name_ny8e0n$_0;
    }
  });
  KLoggerDirect.prototype.at_oj83f8$$default = function (level, marker, block) {
    if (this.isLoggingEnabledFor_29zy0j$(level, marker)) {
      var $receiver = new KLoggingEventBuilder();
      block($receiver);
      if (!equals(level, Level$OFF_getInstance()))
        KotlinLoggingConfiguration_getInstance().appender.log_yeoadr$(KLoggingEvent_init(level, marker, this.name, $receiver));
    }
  };
  KLoggerDirect.prototype.isLoggingEnabledFor_29zy0j$$default = function (level, marker) {
    return isLoggingEnabled(level);
  };
  KLoggerDirect.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'KLoggerDirect',
    interfaces: [KLogger]
  };
  function KLoggerFactory() {
    KLoggerFactory_instance = this;
  }
  KLoggerFactory.prototype.logger_61zpoe$ = function (name) {
    return new KLoggerDirect(name);
  };
  KLoggerFactory.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLoggerFactory',
    interfaces: []
  };
  var KLoggerFactory_instance = null;
  function KLoggerFactory_getInstance() {
    if (KLoggerFactory_instance === null) {
      new KLoggerFactory();
    }
    return KLoggerFactory_instance;
  }
  function ConsoleOutputAppender() {
    FormattingAppender.call(this);
  }
  ConsoleOutputAppender.prototype.logFormattedMessage_wwvt2z$ = function (loggingEvent, formattedMessage) {
    switch (loggingEvent.level.name) {
      case 'TRACE':
        console.log(formattedMessage);
        break;
      case 'DEBUG':
        console.log(formattedMessage);
        break;
      case 'INFO':
        console.info(formattedMessage);
        break;
      case 'WARN':
        console.warn(formattedMessage);
        break;
      case 'ERROR':
        console.error(formattedMessage);
        break;
      case 'OFF':
        break;
    }
  };
  ConsoleOutputAppender.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'ConsoleOutputAppender',
    interfaces: [FormattingAppender]
  };
  function logger($receiver) {
    return new LoggerDelegate();
  }
  function LoggerDelegate() {
    this.logger_itmjkq$_0 = this.logger_itmjkq$_0;
  }
  Object.defineProperty(LoggerDelegate.prototype, 'logger_0', {
    configurable: true,
    get: function () {
      if (this.logger_itmjkq$_0 == null)
        return throwUPAE('logger');
      return this.logger_itmjkq$_0;
    },
    set: function (logger) {
      this.logger_itmjkq$_0 = logger;
    }
  });
  LoggerDelegate.prototype.getValue_lrcp0p$ = function (thisRef, property) {
    var tmp$, tmp$_0, tmp$_1;
    if (this.logger_itmjkq$_0 == null) {
      this.logger_0 = (tmp$_1 = (tmp$_0 = (tmp$ = thisRef != null ? thisRef.constructor : null) != null ? tmp$.name : null) != null ? KotlinLogging_getInstance().logger_61zpoe$(tmp$_0) : null) != null ? tmp$_1 : KotlinLogging_getInstance().logger_61zpoe$('root-logger');
    }
    return this.logger_0;
  };
  LoggerDelegate.$metadata$ = {
    kind: Kind_CLASS,
    simpleName: 'LoggerDelegate',
    interfaces: [ReadOnlyProperty]
  };
  function KotlinLoggingConfiguration() {
    KotlinLoggingConfiguration_instance = this;
    this.logLevel = Level$INFO_getInstance();
    this.formatter = new DefaultMessageFormatter(true);
    this.appender = new ConsoleOutputAppender();
  }
  Object.defineProperty(KotlinLoggingConfiguration.prototype, 'APPENDER', {
    configurable: true,
    get: function () {
      return this.appender;
    },
    set: function (value) {
      this.appender = value;
    }
  });
  Object.defineProperty(KotlinLoggingConfiguration.prototype, 'LOG_LEVEL', {
    configurable: true,
    get: function () {
      return this.logLevel;
    },
    set: function (value) {
      this.logLevel = value;
    }
  });
  KotlinLoggingConfiguration.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KotlinLoggingConfiguration',
    interfaces: []
  };
  var KotlinLoggingConfiguration_instance = null;
  function KotlinLoggingConfiguration_getInstance() {
    if (KotlinLoggingConfiguration_instance === null) {
      new KotlinLoggingConfiguration();
    }
    return KotlinLoggingConfiguration_instance;
  }
  function KLoggerNameResolver() {
    KLoggerNameResolver_instance = this;
  }
  KLoggerNameResolver.prototype.name_ls4sck$ = function (func) {
    var tmp$;
    var found = false;
    var exception = Exception_init();
    tmp$ = split(stackTraceToString(exception), ['\n']).iterator();
    while (tmp$.hasNext()) {
      var line = tmp$.next();
      if (found) {
        return substringAfterLast(substringAfterLast(substringBefore(line, '.kt'), '.'), '/');
      }
      if (contains(line, 'at KotlinLogging')) {
        found = true;
      }
    }
    return '';
  };
  KLoggerNameResolver.$metadata$ = {
    kind: Kind_OBJECT,
    simpleName: 'KLoggerNameResolver',
    interfaces: []
  };
  var KLoggerNameResolver_instance = null;
  function KLoggerNameResolver_getInstance() {
    if (KLoggerNameResolver_instance === null) {
      new KLoggerNameResolver();
    }
    return KLoggerNameResolver_instance;
  }
  var package$io = _.io || (_.io = {});
  var package$github = package$io.github || (package$io.github = {});
  var package$oshai = package$github.oshai || (package$github.oshai = {});
  var package$kotlinlogging = package$oshai.kotlinlogging || (package$oshai.kotlinlogging = {});
  package$kotlinlogging.DelegatingKLogger = DelegatingKLogger;
  package$kotlinlogging.KLogger = KLogger;
  package$kotlinlogging.KLoggingEventBuilder = KLoggingEventBuilder;
  Object.defineProperty(package$kotlinlogging, 'KMarkerFactory', {
    get: KMarkerFactory_getInstance
  });
  Object.defineProperty(package$kotlinlogging, 'KotlinLogging', {
    get: KotlinLogging_getInstance
  });
  Object.defineProperty(Level, 'TRACE', {
    get: Level$TRACE_getInstance
  });
  Object.defineProperty(Level, 'DEBUG', {
    get: Level$DEBUG_getInstance
  });
  Object.defineProperty(Level, 'INFO', {
    get: Level$INFO_getInstance
  });
  Object.defineProperty(Level, 'WARN', {
    get: Level$WARN_getInstance
  });
  Object.defineProperty(Level, 'ERROR', {
    get: Level$ERROR_getInstance
  });
  Object.defineProperty(Level, 'OFF', {
    get: Level$OFF_getInstance
  });
  package$kotlinlogging.Level = Level;
  Object.defineProperty(package$kotlinlogging, 'Levels', {
    get: Levels_getInstance
  });
  package$kotlinlogging.Marker = Marker;
  package$kotlinlogging.SimpleMarker = SimpleMarker;
  var package$internal = package$kotlinlogging.internal || (package$kotlinlogging.internal = {});
  package$internal.toStringSafe_qhgloa$ = toStringSafe;
  Object.defineProperty(package$internal, 'DefaultErrorMessageProducer', {
    get: DefaultErrorMessageProducer_getInstance
  });
  package$kotlinlogging.Appender = Appender;
  package$kotlinlogging.FormattingAppender = FormattingAppender;
  package$kotlinlogging.Formatter = Formatter;
  package$kotlinlogging.DefaultMessageFormatter = DefaultMessageFormatter;
  package$kotlinlogging.KLoggingEvent_init_rgrupd$ = KLoggingEvent_init;
  package$kotlinlogging.KLoggingEvent = KLoggingEvent;
  package$kotlinlogging.isLoggingEnabled_pui99c$ = isLoggingEnabled;
  package$internal.KLoggerDirect = KLoggerDirect;
  Object.defineProperty(package$internal, 'KLoggerFactory', {
    get: KLoggerFactory_getInstance
  });
  package$kotlinlogging.ConsoleOutputAppender = ConsoleOutputAppender;
  package$kotlinlogging.logger_x0fv0a$ = logger;
  Object.defineProperty(package$kotlinlogging, 'KotlinLoggingConfiguration', {
    get: KotlinLoggingConfiguration_getInstance
  });
  Object.defineProperty(package$internal, 'KLoggerNameResolver', {
    get: KLoggerNameResolver_getInstance
  });
  KLoggerDirect.prototype.trace_nq59yw$ = KLogger.prototype.trace_nq59yw$;
  KLoggerDirect.prototype.trace_ca4k3s$ = KLogger.prototype.trace_ca4k3s$;
  KLoggerDirect.prototype.trace_16r1tg$ = KLogger.prototype.trace_16r1tg$;
  KLoggerDirect.prototype.trace_unuu8c$ = KLogger.prototype.trace_unuu8c$;
  KLoggerDirect.prototype.trace_o7l9n0$ = KLogger.prototype.trace_o7l9n0$;
  KLoggerDirect.prototype.trace_pdl1vj$ = KLogger.prototype.trace_pdl1vj$;
  KLoggerDirect.prototype.trace_67rc9h$ = KLogger.prototype.trace_67rc9h$;
  KLoggerDirect.prototype.trace_lzc6tz$ = KLogger.prototype.trace_lzc6tz$;
  KLoggerDirect.prototype.trace_c7dlu0$ = KLogger.prototype.trace_c7dlu0$;
  KLoggerDirect.prototype.trace_wspj0f$ = KLogger.prototype.trace_wspj0f$;
  KLoggerDirect.prototype.trace_9i0b99$ = KLogger.prototype.trace_9i0b99$;
  KLoggerDirect.prototype.trace_hh0jo1$ = KLogger.prototype.trace_hh0jo1$;
  KLoggerDirect.prototype.trace_z116hx$ = KLogger.prototype.trace_z116hx$;
  KLoggerDirect.prototype.trace_qha0wc$ = KLogger.prototype.trace_qha0wc$;
  KLoggerDirect.prototype.trace_lux9z7$ = KLogger.prototype.trace_lux9z7$;
  KLoggerDirect.prototype.debug_nq59yw$ = KLogger.prototype.debug_nq59yw$;
  KLoggerDirect.prototype.debug_ca4k3s$ = KLogger.prototype.debug_ca4k3s$;
  KLoggerDirect.prototype.debug_16r1tg$ = KLogger.prototype.debug_16r1tg$;
  KLoggerDirect.prototype.debug_unuu8c$ = KLogger.prototype.debug_unuu8c$;
  KLoggerDirect.prototype.debug_o7l9n0$ = KLogger.prototype.debug_o7l9n0$;
  KLoggerDirect.prototype.debug_pdl1vj$ = KLogger.prototype.debug_pdl1vj$;
  KLoggerDirect.prototype.debug_67rc9h$ = KLogger.prototype.debug_67rc9h$;
  KLoggerDirect.prototype.debug_lzc6tz$ = KLogger.prototype.debug_lzc6tz$;
  KLoggerDirect.prototype.debug_c7dlu0$ = KLogger.prototype.debug_c7dlu0$;
  KLoggerDirect.prototype.debug_wspj0f$ = KLogger.prototype.debug_wspj0f$;
  KLoggerDirect.prototype.debug_9i0b99$ = KLogger.prototype.debug_9i0b99$;
  KLoggerDirect.prototype.debug_hh0jo1$ = KLogger.prototype.debug_hh0jo1$;
  KLoggerDirect.prototype.debug_z116hx$ = KLogger.prototype.debug_z116hx$;
  KLoggerDirect.prototype.debug_qha0wc$ = KLogger.prototype.debug_qha0wc$;
  KLoggerDirect.prototype.debug_lux9z7$ = KLogger.prototype.debug_lux9z7$;
  KLoggerDirect.prototype.info_nq59yw$ = KLogger.prototype.info_nq59yw$;
  KLoggerDirect.prototype.info_ca4k3s$ = KLogger.prototype.info_ca4k3s$;
  KLoggerDirect.prototype.info_16r1tg$ = KLogger.prototype.info_16r1tg$;
  KLoggerDirect.prototype.info_unuu8c$ = KLogger.prototype.info_unuu8c$;
  KLoggerDirect.prototype.info_o7l9n0$ = KLogger.prototype.info_o7l9n0$;
  KLoggerDirect.prototype.info_pdl1vj$ = KLogger.prototype.info_pdl1vj$;
  KLoggerDirect.prototype.info_67rc9h$ = KLogger.prototype.info_67rc9h$;
  KLoggerDirect.prototype.info_lzc6tz$ = KLogger.prototype.info_lzc6tz$;
  KLoggerDirect.prototype.info_c7dlu0$ = KLogger.prototype.info_c7dlu0$;
  KLoggerDirect.prototype.info_wspj0f$ = KLogger.prototype.info_wspj0f$;
  KLoggerDirect.prototype.info_9i0b99$ = KLogger.prototype.info_9i0b99$;
  KLoggerDirect.prototype.info_hh0jo1$ = KLogger.prototype.info_hh0jo1$;
  KLoggerDirect.prototype.info_z116hx$ = KLogger.prototype.info_z116hx$;
  KLoggerDirect.prototype.info_qha0wc$ = KLogger.prototype.info_qha0wc$;
  KLoggerDirect.prototype.info_lux9z7$ = KLogger.prototype.info_lux9z7$;
  KLoggerDirect.prototype.warn_nq59yw$ = KLogger.prototype.warn_nq59yw$;
  KLoggerDirect.prototype.warn_ca4k3s$ = KLogger.prototype.warn_ca4k3s$;
  KLoggerDirect.prototype.warn_16r1tg$ = KLogger.prototype.warn_16r1tg$;
  KLoggerDirect.prototype.warn_unuu8c$ = KLogger.prototype.warn_unuu8c$;
  KLoggerDirect.prototype.warn_o7l9n0$ = KLogger.prototype.warn_o7l9n0$;
  KLoggerDirect.prototype.warn_pdl1vj$ = KLogger.prototype.warn_pdl1vj$;
  KLoggerDirect.prototype.warn_67rc9h$ = KLogger.prototype.warn_67rc9h$;
  KLoggerDirect.prototype.warn_c7dlu0$ = KLogger.prototype.warn_c7dlu0$;
  KLoggerDirect.prototype.warn_lzc6tz$ = KLogger.prototype.warn_lzc6tz$;
  KLoggerDirect.prototype.warn_wspj0f$ = KLogger.prototype.warn_wspj0f$;
  KLoggerDirect.prototype.warn_9i0b99$ = KLogger.prototype.warn_9i0b99$;
  KLoggerDirect.prototype.warn_hh0jo1$ = KLogger.prototype.warn_hh0jo1$;
  KLoggerDirect.prototype.warn_z116hx$ = KLogger.prototype.warn_z116hx$;
  KLoggerDirect.prototype.warn_qha0wc$ = KLogger.prototype.warn_qha0wc$;
  KLoggerDirect.prototype.warn_lux9z7$ = KLogger.prototype.warn_lux9z7$;
  KLoggerDirect.prototype.error_nq59yw$ = KLogger.prototype.error_nq59yw$;
  KLoggerDirect.prototype.error_ca4k3s$ = KLogger.prototype.error_ca4k3s$;
  KLoggerDirect.prototype.error_16r1tg$ = KLogger.prototype.error_16r1tg$;
  KLoggerDirect.prototype.error_unuu8c$ = KLogger.prototype.error_unuu8c$;
  KLoggerDirect.prototype.error_o7l9n0$ = KLogger.prototype.error_o7l9n0$;
  KLoggerDirect.prototype.error_pdl1vj$ = KLogger.prototype.error_pdl1vj$;
  KLoggerDirect.prototype.error_67rc9h$ = KLogger.prototype.error_67rc9h$;
  KLoggerDirect.prototype.error_lzc6tz$ = KLogger.prototype.error_lzc6tz$;
  KLoggerDirect.prototype.error_c7dlu0$ = KLogger.prototype.error_c7dlu0$;
  KLoggerDirect.prototype.error_wspj0f$ = KLogger.prototype.error_wspj0f$;
  KLoggerDirect.prototype.error_9i0b99$ = KLogger.prototype.error_9i0b99$;
  KLoggerDirect.prototype.error_hh0jo1$ = KLogger.prototype.error_hh0jo1$;
  KLoggerDirect.prototype.error_z116hx$ = KLogger.prototype.error_z116hx$;
  KLoggerDirect.prototype.error_qha0wc$ = KLogger.prototype.error_qha0wc$;
  KLoggerDirect.prototype.error_lux9z7$ = KLogger.prototype.error_lux9z7$;
  KLoggerDirect.prototype.atTrace_svfspb$$default = KLogger.prototype.atTrace_svfspb$$default;
  KLoggerDirect.prototype.atDebug_svfspb$$default = KLogger.prototype.atDebug_svfspb$$default;
  KLoggerDirect.prototype.atInfo_svfspb$$default = KLogger.prototype.atInfo_svfspb$$default;
  KLoggerDirect.prototype.atWarn_svfspb$$default = KLogger.prototype.atWarn_svfspb$$default;
  KLoggerDirect.prototype.atError_svfspb$$default = KLogger.prototype.atError_svfspb$$default;
  KLoggerDirect.prototype.entry_yhszz7$ = KLogger.prototype.entry_yhszz7$;
  KLoggerDirect.prototype.exit = KLogger.prototype.exit;
  KLoggerDirect.prototype.exit_mh5how$ = KLogger.prototype.exit_mh5how$;
  KLoggerDirect.prototype.throwing_849n7l$ = KLogger.prototype.throwing_849n7l$;
  KLoggerDirect.prototype.catching_849n7l$ = KLogger.prototype.catching_849n7l$;
  KLoggerDirect.prototype.isTraceEnabled_77d0nk$$default = KLogger.prototype.isTraceEnabled_77d0nk$$default;
  KLoggerDirect.prototype.isDebugEnabled_77d0nk$$default = KLogger.prototype.isDebugEnabled_77d0nk$$default;
  KLoggerDirect.prototype.isInfoEnabled_77d0nk$$default = KLogger.prototype.isInfoEnabled_77d0nk$$default;
  KLoggerDirect.prototype.isWarnEnabled_77d0nk$$default = KLogger.prototype.isWarnEnabled_77d0nk$$default;
  KLoggerDirect.prototype.isErrorEnabled_77d0nk$$default = KLogger.prototype.isErrorEnabled_77d0nk$$default;
  KLoggerDirect.prototype.isLoggingOff_77d0nk$$default = KLogger.prototype.isLoggingOff_77d0nk$$default;
  Object.defineProperty(KLoggerDirect.prototype, 'isTraceEnabled', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isTraceEnabled'));
  Object.defineProperty(KLoggerDirect.prototype, 'isDebugEnabled', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isDebugEnabled'));
  Object.defineProperty(KLoggerDirect.prototype, 'isInfoEnabled', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isInfoEnabled'));
  Object.defineProperty(KLoggerDirect.prototype, 'isWarnEnabled', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isWarnEnabled'));
  Object.defineProperty(KLoggerDirect.prototype, 'isErrorEnabled', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isErrorEnabled'));
  Object.defineProperty(KLoggerDirect.prototype, 'isLoggingOff', Object.getOwnPropertyDescriptor(KLogger.prototype, 'isLoggingOff'));
  KLoggerDirect.prototype.at_oj83f8$ = KLogger.prototype.at_oj83f8$;
  KLoggerDirect.prototype.isLoggingEnabledFor_29zy0j$ = KLogger.prototype.isLoggingEnabledFor_29zy0j$;
  KLoggerDirect.prototype.atTrace_svfspb$ = KLogger.prototype.atTrace_svfspb$;
  KLoggerDirect.prototype.atDebug_svfspb$ = KLogger.prototype.atDebug_svfspb$;
  KLoggerDirect.prototype.atInfo_svfspb$ = KLogger.prototype.atInfo_svfspb$;
  KLoggerDirect.prototype.atWarn_svfspb$ = KLogger.prototype.atWarn_svfspb$;
  KLoggerDirect.prototype.atError_svfspb$ = KLogger.prototype.atError_svfspb$;
  KLoggerDirect.prototype.isTraceEnabled_77d0nk$ = KLogger.prototype.isTraceEnabled_77d0nk$;
  KLoggerDirect.prototype.isDebugEnabled_77d0nk$ = KLogger.prototype.isDebugEnabled_77d0nk$;
  KLoggerDirect.prototype.isInfoEnabled_77d0nk$ = KLogger.prototype.isInfoEnabled_77d0nk$;
  KLoggerDirect.prototype.isWarnEnabled_77d0nk$ = KLogger.prototype.isWarnEnabled_77d0nk$;
  KLoggerDirect.prototype.isErrorEnabled_77d0nk$ = KLogger.prototype.isErrorEnabled_77d0nk$;
  KLoggerDirect.prototype.isLoggingOff_77d0nk$ = KLogger.prototype.isLoggingOff_77d0nk$;
  Kotlin.defineModule('kotlin-logging-js-legacy', _);
  return _;
}));

//# sourceMappingURL=kotlin-logging-js-legacy.js.map
