/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

import com.openhtmltopdf.util.Diagnostic;
import com.openhtmltopdf.util.JDKXRLogger;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class XRLog {
    private static final List<String> LOGGER_NAMES = new ArrayList<String>(20);
    public static final String CONFIG = XRLog.registerLoggerByName("com.openhtmltopdf.config");
    public static final String EXCEPTION = XRLog.registerLoggerByName("com.openhtmltopdf.exception");
    public static final String GENERAL = XRLog.registerLoggerByName("com.openhtmltopdf.general");
    public static final String INIT = XRLog.registerLoggerByName("com.openhtmltopdf.init");
    public static final String JUNIT = XRLog.registerLoggerByName("com.openhtmltopdf.junit");
    public static final String LOAD = XRLog.registerLoggerByName("com.openhtmltopdf.load");
    public static final String MATCH = XRLog.registerLoggerByName("com.openhtmltopdf.match");
    public static final String CASCADE = XRLog.registerLoggerByName("com.openhtmltopdf.cascade");
    public static final String XML_ENTITIES = XRLog.registerLoggerByName("com.openhtmltopdf.load.xml-entities");
    public static final String CSS_PARSE = XRLog.registerLoggerByName("com.openhtmltopdf.css-parse");
    public static final String LAYOUT = XRLog.registerLoggerByName("com.openhtmltopdf.layout");
    public static final String RENDER = XRLog.registerLoggerByName("com.openhtmltopdf.render");
    private static volatile boolean initPending = true;
    private static volatile XRLogger loggerImpl;
    private static volatile Boolean loggingEnabled;

    private static String registerLoggerByName(String loggerName) {
        LOGGER_NAMES.add(loggerName);
        return loggerName;
    }

    public static List<String> listRegisteredLoggers() {
        if (initPending) {
            XRLog.init();
        }
        return new ArrayList<String>(LOGGER_NAMES);
    }

    public static void log(Level level, LogMessageId.LogMessageId0Param logMessageId) {
        XRLog.log(level, logMessageId, false, new Object[0]);
    }

    public static void log(Level level, LogMessageId.LogMessageId0Param logMessageId, Throwable t) {
        XRLog.log(level, logMessageId, true, t);
    }

    public static void log(Level level, LogMessageId.LogMessageId1Param logMessageId, Object arg) {
        XRLog.log(level, (LogMessageId)logMessageId, false, arg);
    }

    public static void log(Level level, LogMessageId.LogMessageId1Param logMessageId, Object arg, Throwable throwable) {
        XRLog.log(level, (LogMessageId)logMessageId, true, arg, throwable);
    }

    public static void log(Level level, LogMessageId.LogMessageId2Param logMessageId, Object arg1, Object arg2) {
        XRLog.log(level, (LogMessageId)logMessageId, false, arg1, arg2);
    }

    public static void log(Level level, LogMessageId.LogMessageId2Param logMessageId, Object arg1, Object arg2, Throwable throwable) {
        XRLog.log(level, (LogMessageId)logMessageId, true, arg1, arg2, throwable);
    }

    public static void log(Level level, LogMessageId.LogMessageId3Param logMessageId, Object arg1, Object arg2, Object arg3) {
        XRLog.log(level, (LogMessageId)logMessageId, false, arg1, arg2, arg3);
    }

    public static void log(Level level, LogMessageId.LogMessageId3Param logMessageId, Object arg1, Object arg2, Object arg3, Throwable throwable) {
        XRLog.log(level, (LogMessageId)logMessageId, true, arg1, arg2, arg3, throwable);
    }

    public static void log(Level level, LogMessageId.LogMessageId4Param logMessageId, Object arg1, Object arg2, Object arg3, Object arg4) {
        XRLog.log(level, (LogMessageId)logMessageId, false, arg1, arg2, arg3, arg4);
    }

    public static void log(Level level, LogMessageId.LogMessageId5Param logMessageId, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        XRLog.log(level, (LogMessageId)logMessageId, false, arg1, arg2, arg3, arg4, arg5);
    }

    private static void log(Level level, LogMessageId logMessageId, boolean hasError, Object ... args) {
        if (initPending) {
            XRLog.init();
        }
        if (XRLog.isLoggingEnabled()) {
            Diagnostic diagnostic = new Diagnostic(level, logMessageId, hasError, args);
            if (loggerImpl.isLogLevelEnabled(diagnostic)) {
                loggerImpl.log(diagnostic);
            }
            ThreadCtx.addDiagnostic(diagnostic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<XRLog> clazz = XRLog.class;
        synchronized (XRLog.class) {
            if (!initPending) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (loggingEnabled == null) {
                XRLog.setLoggingEnabled(true);
            }
            if (loggerImpl == null) {
                loggerImpl = new JDKXRLogger();
            }
            initPending = false;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void setLevel(String log, Level level) {
        if (initPending) {
            XRLog.init();
        }
        loggerImpl.setLevel(log, level);
    }

    public static boolean isLoggingEnabled() {
        return loggingEnabled == true;
    }

    public static void setLoggingEnabled(boolean loggingEnabled) {
        XRLog.loggingEnabled = loggingEnabled;
    }

    public static synchronized XRLogger getLoggerImpl() {
        return loggerImpl;
    }

    public static synchronized void setLoggerImpl(XRLogger loggerImpl) {
        XRLog.loggerImpl = loggerImpl;
    }
}

