/*
 * Decompiled with CFR 0.152.
 */
package feign.form.multipart;

import feign.form.multipart.Output;
import feign.form.multipart.Writer;
import java.net.URLConnection;

public abstract class AbstractWriter
implements Writer {
    @Override
    public void write(Output output, String boundary, String key, Object value) throws Exception {
        output.write("--").write(boundary).write("\r\n");
        this.write(output, key, value);
        output.write("\r\n");
    }

    protected void write(Output output, String key, Object value) throws Exception {
    }

    protected void writeFileMetadata(Output output, String name, String fileName, String contentType) {
        String contentDesposition = "Content-Disposition: form-data; name=\"" + name + "\"; " + "filename=\"" + fileName + "\"";
        String fileContentType = contentType;
        if (fileContentType == null) {
            if (fileName != null) {
                fileContentType = URLConnection.guessContentTypeFromName(fileName);
            }
            if (fileContentType == null) {
                fileContentType = "application/octet-stream";
            }
        }
        String string = contentDesposition + "\r\n" + "Content-Type: " + fileContentType + "\r\n" + "Content-Transfer-Encoding: binary" + "\r\n" + "\r\n";
        output.write(string);
    }
}

