/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.codec.Encoder;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import feign.form.multipart.ByteArrayWriter;
import feign.form.multipart.DelegateWriter;
import feign.form.multipart.FormDataWriter;
import feign.form.multipart.ManyFilesWriter;
import feign.form.multipart.Output;
import feign.form.multipart.ParameterWriter;
import feign.form.multipart.SingleFileWriter;
import feign.form.multipart.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MultipartFormContentProcessor
implements ContentProcessor {
    private final List<Writer> writers = new ArrayList<Writer>(6);
    private final Writer defaultPerocessor;

    public MultipartFormContentProcessor(Encoder delegate) {
        this.addWriter(new ByteArrayWriter());
        this.addWriter(new FormDataWriter());
        this.addWriter(new SingleFileWriter());
        this.addWriter(new ManyFilesWriter());
        this.addWriter(new ParameterWriter());
        this.defaultPerocessor = new DelegateWriter(delegate);
    }

    @Override
    public void process(RequestTemplate template, Charset charset, Map<String, Object> data) throws Exception {
        String boundary = Long.toHexString(System.currentTimeMillis());
        Output output = new Output(charset);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            Writer writer = this.findApplicableWriter(entry.getValue());
            writer.write(output, boundary, entry.getKey(), entry.getValue());
        }
        output.write("--").write(boundary).write("--").write("\r\n");
        String contentTypeHeaderValue = this.getSupportedContentType().getHeader() + "; charset=" + charset.name() + "; boundary=" + boundary;
        template.header("Content-Type", new String[]{contentTypeHeaderValue});
        template.body(output.toByteArray(), null);
        output.close();
    }

    @Override
    public ContentType getSupportedContentType() {
        return ContentType.MULTIPART;
    }

    public final void addWriter(Writer writer) {
        this.writers.add(writer);
    }

    public final List<Writer> getWriters() {
        return Collections.unmodifiableList(this.writers);
    }

    public final void setWriter(int index, Writer writer) {
        this.writers.set(index, writer);
    }

    private Writer findApplicableWriter(Object value) {
        for (Writer writer : this.writers) {
            if (!writer.isApplicable(value)) continue;
            return writer;
        }
        return this.defaultPerocessor;
    }
}

