/*
 * Decompiled with CFR 0.152.
 */
package feign.form;

import feign.RequestTemplate;
import feign.form.ContentProcessor;
import feign.form.ContentType;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlencodedFormContentProcessor
implements ContentProcessor {
    @Override
    public void process(RequestTemplate template, Charset charset, Map<String, Object> data) throws Exception {
        StringBuilder body = new StringBuilder();
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            if (body.length() > 0) {
                body.append('&');
            }
            body.append(this.createKeyValuePair(entry, charset));
        }
        String contentTypeValue = this.getSupportedContentType().getHeader() + "; charset=" + charset.name();
        template.header("Content-Type", new String[]{contentTypeValue});
        template.body(body.toString().getBytes(charset), charset);
    }

    @Override
    public ContentType getSupportedContentType() {
        return ContentType.URLENCODED;
    }

    private String createKeyValuePair(Map.Entry<String, Object> entry, Charset charset) {
        return URLEncoder.encode(entry.getKey(), charset.name()) + '=' + URLEncoder.encode(entry.getValue().toString(), charset.name());
    }
}

