/*
 * Decompiled with CFR 0.152.
 */
package feign.form.spring;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.form.ContentType;
import feign.form.FormEncoder;
import feign.form.MultipartFormContentProcessor;
import feign.form.multipart.Writer;
import feign.form.spring.SpringManyMultipartFilesWriter;
import feign.form.spring.SpringSingleMultipartFileWriter;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import org.springframework.web.multipart.MultipartFile;

public class SpringFormEncoder
extends FormEncoder {
    public SpringFormEncoder() {
        this((Encoder)new Encoder.Default());
    }

    public SpringFormEncoder(Encoder delegate) {
        super(delegate);
        MultipartFormContentProcessor processor = (MultipartFormContentProcessor)this.getContentProcessor(ContentType.MULTIPART);
        processor.addFirstWriter((Writer)new SpringSingleMultipartFileWriter());
        processor.addFirstWriter((Writer)new SpringManyMultipartFilesWriter());
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        if (!bodyType.equals(MultipartFile.class)) {
            super.encode(object, bodyType, template);
            return;
        }
        MultipartFile file = (MultipartFile)object;
        Map<String, Object> data = Collections.singletonMap(file.getName(), object);
        super.encode(data, MAP_STRING_WILDCARD, template);
    }
}

