/*
 * Decompiled with CFR 0.152.
 */
package feign.soap;

import feign.Response;
import feign.codec.ErrorDecoder;
import java.io.IOException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.soap.SOAPFaultException;

public class SOAPErrorDecoder
implements ErrorDecoder {
    private final String soapProtocol;

    public SOAPErrorDecoder() {
        this.soapProtocol = "SOAP 1.1 Protocol";
    }

    public SOAPErrorDecoder(String soapProtocol) {
        this.soapProtocol = soapProtocol;
    }

    public Exception decode(String methodKey, Response response) {
        if (response.body() == null || response.status() == 503) {
            return this.defaultErrorDecoder(methodKey, response);
        }
        try {
            SOAPMessage message = MessageFactory.newInstance((String)this.soapProtocol).createMessage(null, response.body().asInputStream());
            if (message.getSOAPBody() != null && message.getSOAPBody().hasFault()) {
                return new SOAPFaultException(message.getSOAPBody().getFault());
            }
        }
        catch (IOException | SOAPException throwable) {
            // empty catch block
        }
        return this.defaultErrorDecoder(methodKey, response);
    }

    private Exception defaultErrorDecoder(String methodKey, Response response) {
        return new ErrorDecoder.Default().decode(methodKey, response);
    }
}

