/*
 * Decompiled with CFR 0.152.
 */
package feign.reactive;

import feign.InvocationHandlerFactory;
import feign.Target;
import feign.reactive.ReactiveInvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public class ReactorInvocationHandler
extends ReactiveInvocationHandler {
    ReactorInvocationHandler(Target<?> target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
        super(target, dispatch);
    }

    @Override
    protected Publisher invoke(Method method, InvocationHandlerFactory.MethodHandler methodHandler, Object[] arguments) {
        Callable<?> invocation = this.invokeMethod(methodHandler, arguments);
        if (Flux.class.isAssignableFrom(method.getReturnType())) {
            return Flux.from((Publisher)Mono.fromCallable(invocation)).subscribeOn(Schedulers.elastic());
        }
        if (Mono.class.isAssignableFrom(method.getReturnType())) {
            return Mono.fromCallable(invocation).subscribeOn(Schedulers.elastic());
        }
        throw new IllegalArgumentException("Return type " + method.getReturnType().getName() + " is not supported");
    }
}

