/*
 * Decompiled with CFR 0.152.
 */
package feign.mock;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.Util;
import feign.mock.HttpMethod;
import feign.mock.RequestHeaders;
import feign.mock.RequestKey;
import feign.mock.VerificationAssertionError;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MockClient
implements Client {
    private final List<RequestResponse> responses = new ArrayList<RequestResponse>();
    private final Map<RequestKey, List<Request>> requests = new HashMap<RequestKey, List<Request>>();
    private boolean sequential;
    private Iterator<RequestResponse> responseIterator;

    public MockClient() {
    }

    public MockClient(boolean sequential) {
        this.sequential = sequential;
    }

    public synchronized Response execute(Request request, Request.Options options) throws IOException {
        RequestKey requestKey = RequestKey.create(request);
        Response.Builder responseBuilder = this.sequential ? this.executeSequential(requestKey) : this.executeAny(request, requestKey);
        responseBuilder.protocolVersion(Request.ProtocolVersion.MOCK);
        return responseBuilder.request(request).build();
    }

    private Response.Builder executeSequential(RequestKey requestKey) {
        if (this.responseIterator == null) {
            this.responseIterator = this.responses.iterator();
        }
        if (!this.responseIterator.hasNext()) {
            throw new VerificationAssertionError("Received excessive request %s", requestKey);
        }
        RequestResponse expectedRequestResponse = this.responseIterator.next();
        if (!expectedRequestResponse.requestKey.equalsExtended(requestKey)) {
            throw new VerificationAssertionError("Expected: \n%s,\nbut was: \n%s", expectedRequestResponse.requestKey, requestKey);
        }
        Response.Builder responseBuilder = expectedRequestResponse.responseBuilder;
        return responseBuilder;
    }

    private Response.Builder executeAny(Request request, RequestKey requestKey) {
        if (this.requests.containsKey(requestKey)) {
            this.requests.get(requestKey).add(request);
        } else {
            this.requests.put(requestKey, new ArrayList<Request>(Arrays.asList(request)));
        }
        Response.Builder responseBuilder = this.getResponseBuilder(request, requestKey);
        return responseBuilder;
    }

    private Response.Builder getResponseBuilder(Request request, RequestKey requestKey) {
        Response.Builder responseBuilder = null;
        for (RequestResponse requestResponse : this.responses) {
            if (!requestResponse.requestKey.equalsExtended(requestKey)) continue;
            responseBuilder = requestResponse.responseBuilder;
        }
        if (responseBuilder == null) {
            responseBuilder = Response.builder().status(404).reason("Not mocker").headers(request.headers());
        }
        return responseBuilder;
    }

    public MockClient ok(HttpMethod method, String url, InputStream responseBody) throws IOException {
        return this.ok(RequestKey.builder(method, url).build(), responseBody);
    }

    public MockClient ok(HttpMethod method, String url, String responseBody) {
        return this.ok(RequestKey.builder(method, url).build(), responseBody);
    }

    public MockClient ok(HttpMethod method, String url, byte[] responseBody) {
        return this.ok(RequestKey.builder(method, url).build(), responseBody);
    }

    public MockClient ok(HttpMethod method, String url) {
        return this.ok(RequestKey.builder(method, url).build());
    }

    public MockClient ok(RequestKey requestKey, InputStream responseBody) throws IOException {
        return this.ok(requestKey, Util.toByteArray((InputStream)responseBody));
    }

    public MockClient ok(RequestKey requestKey, String responseBody) {
        return this.ok(requestKey, responseBody.getBytes(Util.UTF_8));
    }

    public MockClient ok(RequestKey requestKey, byte[] responseBody) {
        return this.add(requestKey, 200, responseBody);
    }

    public MockClient ok(RequestKey requestKey) {
        return this.ok(requestKey, (byte[])null);
    }

    public MockClient add(HttpMethod method, String url, int status, InputStream responseBody) throws IOException {
        return this.add(RequestKey.builder(method, url).build(), status, responseBody);
    }

    public MockClient add(HttpMethod method, String url, int status, String responseBody) {
        return this.add(RequestKey.builder(method, url).build(), status, responseBody);
    }

    public MockClient add(HttpMethod method, String url, int status, byte[] responseBody) {
        return this.add(RequestKey.builder(method, url).build(), status, responseBody);
    }

    public MockClient add(HttpMethod method, String url, int status) {
        return this.add(RequestKey.builder(method, url).build(), status);
    }

    public MockClient add(HttpMethod method, String url, Response.Builder response) {
        return this.add(RequestKey.builder(method, url).build(), response);
    }

    public MockClient add(RequestKey requestKey, int status, InputStream responseBody) throws IOException {
        return this.add(requestKey, status, Util.toByteArray((InputStream)responseBody));
    }

    public MockClient add(RequestKey requestKey, int status, String responseBody) {
        return this.add(requestKey, status, responseBody.getBytes(Util.UTF_8));
    }

    public MockClient add(RequestKey requestKey, int status, byte[] responseBody) {
        return this.add(requestKey, Response.builder().status(status).reason("Mocked").headers(RequestHeaders.EMPTY).body(responseBody));
    }

    public MockClient add(RequestKey requestKey, int status) {
        return this.add(requestKey, status, (byte[])null);
    }

    public MockClient add(RequestKey requestKey, Response.Builder response) {
        this.responses.add(new RequestResponse(requestKey, response));
        return this;
    }

    @Deprecated
    public MockClient add(HttpMethod method, String url, Response response) {
        return this.add(method, url, response.toBuilder());
    }

    public MockClient noContent(HttpMethod method, String url) {
        return this.add(method, url, 204);
    }

    public Request verifyOne(HttpMethod method, String url) {
        return this.verifyTimes(method, url, 1).get(0);
    }

    public Request verifyOne(RequestKey requestKey) {
        return this.verifyTimes(requestKey, 1).get(0);
    }

    public List<Request> verifyTimes(HttpMethod method, String url, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times must be a non negative number");
        }
        if (times == 0) {
            this.verifyNever(method, url);
            return Collections.emptyList();
        }
        RequestKey requestKey = RequestKey.builder(method, url).build();
        if (!this.requests.containsKey(requestKey)) {
            throw new VerificationAssertionError("Wanted: '%s' but never invoked! Got: %s", requestKey, this.requests.keySet());
        }
        List<Request> result = this.requests.get(requestKey);
        if (result.size() != times) {
            throw new VerificationAssertionError("Wanted: '%s' to be invoked: '%s' times but got: '%s'!", requestKey, times, result.size());
        }
        return result;
    }

    public List<Request> verifyTimes(RequestKey requestKey, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("times must be a non negative number");
        }
        if (times == 0) {
            this.verifyNever(requestKey);
            return Collections.emptyList();
        }
        List<Request> result = null;
        for (Map.Entry<RequestKey, List<Request>> request : this.requests.entrySet()) {
            if (!request.getKey().equalsExtended(requestKey)) continue;
            result = request.getValue();
        }
        if (result == null) {
            throw new VerificationAssertionError("Wanted: '%s' but never invoked! Got: %s", requestKey, this.requests.keySet());
        }
        if (result.size() != times) {
            throw new VerificationAssertionError("Wanted: '%s' to be invoked: '%s' times but got: '%s'!", requestKey, times, result.size());
        }
        return result;
    }

    public void verifyNever(HttpMethod method, String url) {
        RequestKey requestKey = RequestKey.builder(method, url).build();
        if (this.requests.containsKey(requestKey)) {
            throw new VerificationAssertionError("Do not wanted: '%s' but was invoked!", requestKey);
        }
    }

    public void verifyNever(RequestKey requestKey) {
        for (RequestKey recorderRequestKey : this.requests.keySet()) {
            if (!recorderRequestKey.equalsExtended(requestKey)) continue;
            throw new VerificationAssertionError("Do not wanted: '%s' but was invoked!", requestKey);
        }
    }

    public void verifyStatus() {
        if (this.sequential) {
            boolean unopenedIterator;
            boolean bl = unopenedIterator = this.responseIterator == null && !this.responses.isEmpty();
            if (unopenedIterator || this.responseIterator.hasNext()) {
                throw new VerificationAssertionError("More executions were expected", new Object[0]);
            }
        }
    }

    public void resetRequests() {
        this.requests.clear();
    }

    class RequestResponse {
        private final RequestKey requestKey;
        private final Response.Builder responseBuilder;

        public RequestResponse(RequestKey requestKey, Response.Builder responseBuilder) {
            this.requestKey = requestKey;
            this.responseBuilder = responseBuilder;
        }
    }
}

