/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.AsyncClient;
import feign.FeignException;
import feign.Request;
import feign.Response;
import feign.micrometer.BaseMeteredClient;
import feign.micrometer.FeignMetricName;
import feign.micrometer.FeignMetricTagResolver;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class MeteredAsyncClient
extends BaseMeteredClient
implements AsyncClient<Object> {
    private final AsyncClient<Object> client;

    public MeteredAsyncClient(AsyncClient<Object> client, MeterRegistry meterRegistry) {
        this(client, meterRegistry, new FeignMetricName(AsyncClient.class), new FeignMetricTagResolver());
    }

    public MeteredAsyncClient(AsyncClient<Object> client, MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        super(meterRegistry, metricName, metricTagResolver);
        this.client = client;
    }

    public CompletableFuture<Response> execute(Request request, Request.Options options, Optional<Object> requestContext) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        return this.client.execute(request, options, requestContext).whenComplete((response, th) -> {
            Timer timer;
            if (th == null) {
                this.countResponseCode(request, (Response)response, options, response.status(), null);
                timer = this.createTimer(request, (Response)response, options, null);
            } else if (th instanceof FeignException) {
                FeignException e = (FeignException)th;
                timer = this.createTimer(request, (Response)response, options, (Exception)e);
                this.countResponseCode(request, (Response)response, options, e.status(), (Exception)e);
            } else if (th instanceof Exception) {
                Exception e = (Exception)th;
                timer = this.createTimer(request, (Response)response, options, e);
            } else {
                timer = this.createTimer(request, (Response)response, options, null);
            }
            sample.stop(timer);
        });
    }
}

