/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Request;
import feign.Response;
import feign.micrometer.FeignContext;
import feign.micrometer.FeignObservationConvention;
import feign.micrometer.FeignObservationDocumentation;
import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.lang.Nullable;

public class DefaultFeignObservationConvention
implements FeignObservationConvention {
    public static final DefaultFeignObservationConvention INSTANCE = new DefaultFeignObservationConvention();

    protected DefaultFeignObservationConvention() {
    }

    public String getName() {
        return "http.client.requests";
    }

    public String getContextualName(FeignContext context) {
        return "HTTP " + this.getMethodString((Request)context.getCarrier());
    }

    public KeyValues getLowCardinalityKeyValues(FeignContext context) {
        String templatedUrl = ((Request)context.getCarrier()).requestTemplate().methodMetadata().template().url();
        return KeyValues.of((KeyValue[])new KeyValue[]{FeignObservationDocumentation.HttpClientTags.METHOD.withValue(this.getMethodString((Request)context.getCarrier())), FeignObservationDocumentation.HttpClientTags.URI.withValue(templatedUrl), FeignObservationDocumentation.HttpClientTags.STATUS.withValue(this.getStatusValue((Response)context.getResponse()))});
    }

    String getStatusValue(@Nullable Response response) {
        return response != null ? String.valueOf(response.status()) : "CLIENT_ERROR";
    }

    String getMethodString(@Nullable Request request) {
        if (request == null) {
            return "UNKNOWN";
        }
        return request.httpMethod().name();
    }
}

