/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.micrometer.FeignMetricName;
import feign.micrometer.FeignMetricTagResolver;
import feign.micrometer.MetricName;
import feign.micrometer.MetricTagResolver;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;

public class MeteredClient
implements Client {
    private final Client client;
    private final MeterRegistry meterRegistry;
    private final MetricName metricName;
    private final MetricTagResolver metricTagResolver;

    public MeteredClient(Client client, MeterRegistry meterRegistry) {
        this(client, meterRegistry, new FeignMetricName(Client.class), new FeignMetricTagResolver());
    }

    public MeteredClient(Client client, MeterRegistry meterRegistry, MetricName metricName, MetricTagResolver metricTagResolver) {
        this.client = client;
        this.meterRegistry = meterRegistry;
        this.metricName = metricName;
        this.metricTagResolver = metricTagResolver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        Response response;
        Timer timer;
        Timer.Sample sample;
        block7: {
            sample = Timer.start((MeterRegistry)this.meterRegistry);
            timer = null;
            try {
                Response response2 = this.client.execute(request, options);
                this.countResponseCode(request, response2, options, response2.status(), null);
                timer = this.createTimer(request, response2, options, null);
                sample.stop(timer);
                response = response2;
                if (timer != null) break block7;
            }
            catch (FeignException e) {
                try {
                    timer = this.createTimer(request, null, options, (Exception)((Object)e));
                    this.countResponseCode(request, null, options, e.status(), (Exception)((Object)e));
                    throw e;
                    catch (IOException | RuntimeException e2) {
                        timer = this.createTimer(request, null, options, e2);
                        throw e2;
                    }
                    catch (Exception e3) {
                        timer = this.createTimer(request, null, options, e3);
                        throw new IOException(e3);
                    }
                }
                catch (Throwable throwable) {
                    if (timer == null) {
                        timer = this.createTimer(request, null, options, null);
                    }
                    sample.stop(timer);
                    throw throwable;
                }
            }
            timer = this.createTimer(request, null, options, null);
        }
        sample.stop(timer);
        return response;
    }

    protected void countResponseCode(Request request, Response response, Request.Options options, int responseStatus, Exception e) {
        Tag[] extraTags = this.extraTags(request, response, options, e);
        RequestTemplate template = request.requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), e, Tag.of((String)"http_status", (String)String.valueOf(responseStatus)), Tag.of((String)"status_group", (String)(responseStatus / 100 + "xx")), Tag.of((String)"uri", (String)template.methodMetadata().template().path())).and(extraTags);
        this.meterRegistry.counter(this.metricName.name("http_response_code"), (Iterable)allTags).increment();
    }

    protected Timer createTimer(Request request, Response response, Request.Options options, Exception e) {
        RequestTemplate template = request.requestTemplate();
        Tags allTags = this.metricTagResolver.tag(template.methodMetadata(), template.feignTarget(), e, Tag.of((String)"uri", (String)template.methodMetadata().template().path())).and(this.extraTags(request, response, options, e));
        return this.meterRegistry.timer(this.metricName.name(e), (Iterable)allTags);
    }

    protected Tag[] extraTags(Request request, Response response, Request.Options options, Exception e) {
        return MetricTagResolver.EMPTY_TAGS_ARRAY;
    }
}

