/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.Response;
import feign.Util;
import feign.micrometer.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.function.Supplier;

public final class MeteredBody
implements Response.Body {
    private final Response.Body delegate;
    private Supplier<Long> count;

    public MeteredBody(Response.Body body) {
        this.delegate = body;
        this.count = () -> 0L;
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public Integer length() {
        return this.delegate.length();
    }

    public boolean isRepeatable() {
        return this.delegate.isRepeatable();
    }

    public InputStream asInputStream() throws IOException {
        CountingInputStream input = new CountingInputStream(this.delegate.asInputStream());
        this.count = input::getCount;
        return input;
    }

    public Reader asReader() throws IOException {
        return new InputStreamReader(this.asInputStream(), Util.UTF_8);
    }

    public long count() {
        return this.count.get();
    }

    public Reader asReader(Charset charset) throws IOException {
        return new InputStreamReader(this.asInputStream(), charset);
    }
}

