/*
 * Decompiled with CFR 0.152.
 */
package feign.micrometer;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.micrometer.FeignMetricName;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.lang.reflect.Type;

public class MeteredEncoder
implements Encoder {
    private final Encoder encoder;
    private final MeterRegistry meterRegistry;
    private final FeignMetricName metricName;

    public MeteredEncoder(Encoder encoder, MeterRegistry meterRegistry) {
        this.encoder = encoder;
        this.meterRegistry = meterRegistry;
        this.metricName = new FeignMetricName(Encoder.class);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        this.meterRegistry.timer(this.metricName.name(), this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).record(() -> this.encoder.encode(object, bodyType, template));
        if (template.body() != null) {
            this.meterRegistry.summary(this.metricName.name("request_size"), this.metricName.tag(template.methodMetadata(), template.feignTarget(), new Tag[0])).record((double)template.body().length);
        }
    }
}

