/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxrs2;

import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Variant;

public class JAXRSClient
implements Client {
    private final ClientBuilder clientBuilder;

    public JAXRSClient() {
        this(ClientBuilder.newBuilder());
    }

    public JAXRSClient(ClientBuilder clientBuilder) {
        this.clientBuilder = clientBuilder;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        javax.ws.rs.core.Response response = this.clientBuilder.connectTimeout((long)options.connectTimeoutMillis(), TimeUnit.MILLISECONDS).readTimeout((long)options.readTimeoutMillis(), TimeUnit.MILLISECONDS).build().target(request.url()).request().headers(this.toMultivaluedMap(request.headers())).method(request.httpMethod().name(), this.createRequestEntity(request));
        return Response.builder().request(request).body((InputStream)response.readEntity(InputStream.class), this.integerHeader(response, "Content-Length")).headers(this.toMap((MultivaluedMap<String, String>)response.getStringHeaders())).status(response.getStatus()).reason(response.getStatusInfo().getReasonPhrase()).build();
    }

    private Entity<byte[]> createRequestEntity(Request request) {
        if (request.body() == null) {
            return null;
        }
        return Entity.entity((Object)request.body(), (Variant)new Variant(this.mediaType(request.headers()), this.locale(request.headers()), this.encoding(request.charset())));
    }

    private Integer integerHeader(javax.ws.rs.core.Response response, String header) {
        MultivaluedMap headers = response.getStringHeaders();
        if (!headers.containsKey((Object)header)) {
            return null;
        }
        try {
            return Integer.valueOf((String)headers.getFirst((Object)header));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String encoding(Charset charset) {
        if (charset == null) {
            return null;
        }
        return charset.name();
    }

    private String locale(Map<String, Collection<String>> headers) {
        if (!headers.containsKey("Content-Language")) {
            return null;
        }
        return headers.get("Content-Language").iterator().next();
    }

    private MediaType mediaType(Map<String, Collection<String>> headers) {
        if (!headers.containsKey("Content-Type")) {
            return null;
        }
        return MediaType.valueOf((String)headers.get("Content-Type").iterator().next());
    }

    private MultivaluedMap<String, Object> toMultivaluedMap(Map<String, Collection<String>> headers) {
        MultivaluedHashMap mvHeaders = new MultivaluedHashMap();
        headers.forEach((key, value1) -> value1.forEach(value -> mvHeaders.add(key, value)));
        return mvHeaders;
    }

    private Map<String, Collection<String>> toMap(MultivaluedMap<String, String> headers) {
        return headers.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

