/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxrs;

import feign.DeclarativeContract;
import feign.MethodMetadata;
import feign.Request;
import feign.Util;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.Context;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;

public class JakartaContract
extends DeclarativeContract {
    static final String ACCEPT = "Accept";
    static final String CONTENT_TYPE = "Content-Type";

    protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
        return super.parseAndValidateMetadata(targetType, method);
    }

    public JakartaContract() {
        super.registerClassAnnotation(Path.class, (path, data) -> {
            if (path != null && !path.value().isEmpty()) {
                Object pathValue = path.value();
                if (!((String)pathValue).startsWith("/")) {
                    pathValue = "/" + (String)pathValue;
                }
                if (((String)pathValue).endsWith("/")) {
                    pathValue = ((String)pathValue).substring(0, ((String)pathValue).length() - 1);
                }
                pathValue = ((String)pathValue).replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
                data.template().uri((String)pathValue);
            }
        });
        super.registerClassAnnotation(Consumes.class, this::handleConsumesAnnotation);
        super.registerClassAnnotation(Produces.class, this::handleProducesAnnotation);
        this.registerMethodAnnotation(methodAnnotation -> {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
            return http != null;
        }, (methodAnnotation, data) -> {
            Class<? extends Annotation> annotationType = methodAnnotation.annotationType();
            HttpMethod http = annotationType.getAnnotation(HttpMethod.class);
            Util.checkState((data.template().method() == null ? 1 : 0) != 0, (String)"Method %s contains multiple HTTP methods. Found: %s and %s", (Object[])new Object[]{data.configKey(), data.template().method(), http.value()});
            data.template().method(Request.HttpMethod.valueOf((String)http.value()));
        });
        super.registerMethodAnnotation(Path.class, (path, data) -> {
            String pathValue = Util.emptyToNull((String)path.value());
            if (pathValue == null) {
                return;
            }
            Object methodAnnotationValue = path.value();
            if (!((String)methodAnnotationValue).startsWith("/") && !data.template().url().endsWith("/")) {
                methodAnnotationValue = "/" + (String)methodAnnotationValue;
            }
            methodAnnotationValue = ((String)methodAnnotationValue).replaceAll("\\{\\s*(.+?)\\s*(:.+?)?\\}", "\\{$1\\}");
            data.template().uri((String)methodAnnotationValue, true);
        });
        super.registerMethodAnnotation(Consumes.class, this::handleConsumesAnnotation);
        super.registerMethodAnnotation(Produces.class, this::handleProducesAnnotation);
        super.registerParameterAnnotation(Suspended.class, (ann, data, i) -> data.ignoreParamater(i));
        super.registerParameterAnnotation(Context.class, (ann, data, i) -> data.ignoreParamater(i));
        this.registerParamAnnotations();
    }

    private void handleProducesAnnotation(Produces produces, MethodMetadata data) {
        String[] serverProduces = (String[])Util.removeValues((Object[])produces.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverProduces.length > 0 ? 1 : 0) != 0, (String)"Produces.value() was empty on %s", (Object[])new Object[]{data.configKey()});
        data.template().header(ACCEPT, Collections.emptyList());
        data.template().header(ACCEPT, serverProduces);
    }

    private void handleConsumesAnnotation(Consumes consumes, MethodMetadata data) {
        String[] serverConsumes = (String[])Util.removeValues((Object[])consumes.value(), mediaType -> Util.emptyToNull((String)mediaType) == null, String.class);
        Util.checkState((serverConsumes.length > 0 ? 1 : 0) != 0, (String)"Consumes.value() was empty on %s", (Object[])new Object[]{data.configKey()});
        data.template().header(CONTENT_TYPE, serverConsumes);
    }

    protected void registerParamAnnotations() {
        this.registerParameterAnnotation(PathParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"PathParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(QueryParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"QueryParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            String query = this.addTemplatedParam(name);
            data.template().query(name, new String[]{query});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(HeaderParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"HeaderParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            String header = this.addTemplatedParam(name);
            data.template().header(name, new String[]{header});
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(FormParam.class, (param, data, paramIndex) -> {
            String name = param.value();
            Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"FormParam.value() was empty on parameter %s", (Object[])new Object[]{paramIndex});
            data.formParams().add(name);
            this.nameParam(data, name, paramIndex);
        });
        this.registerParameterAnnotation(BeanParam.class, (param, data, paramIndex) -> {
            Field[] aggregatedParams;
            for (Field aggregatedParam : aggregatedParams = data.method().getParameters()[paramIndex].getType().getDeclaredFields()) {
                String name;
                if (aggregatedParam.isAnnotationPresent(PathParam.class)) {
                    name = aggregatedParam.getAnnotation(PathParam.class).value();
                    Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"BeanParam parameter %s contains PathParam with empty .value() on field %s", (Object[])new Object[]{paramIndex, aggregatedParam.getName()});
                    this.nameParam(data, name, paramIndex);
                }
                if (aggregatedParam.isAnnotationPresent(QueryParam.class)) {
                    name = aggregatedParam.getAnnotation(QueryParam.class).value();
                    Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"BeanParam parameter %s contains QueryParam with empty .value() on field %s", (Object[])new Object[]{paramIndex, aggregatedParam.getName()});
                    String query = this.addTemplatedParam(name);
                    data.template().query(name, new String[]{query});
                    this.nameParam(data, name, paramIndex);
                }
                if (aggregatedParam.isAnnotationPresent(HeaderParam.class)) {
                    name = aggregatedParam.getAnnotation(HeaderParam.class).value();
                    Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"BeanParam parameter %s contains HeaderParam with empty .value() on field %s", (Object[])new Object[]{paramIndex, aggregatedParam.getName()});
                    String header = this.addTemplatedParam(name);
                    data.template().header(name, new String[]{header});
                    this.nameParam(data, name, paramIndex);
                }
                if (!aggregatedParam.isAnnotationPresent(FormParam.class)) continue;
                name = aggregatedParam.getAnnotation(FormParam.class).value();
                Util.checkState((Util.emptyToNull((String)name) != null ? 1 : 0) != 0, (String)"BeanParam parameter %s contains FormParam with empty .value() on field %s", (Object[])new Object[]{paramIndex, aggregatedParam.getName()});
                data.formParams().add(name);
                this.nameParam(data, name, paramIndex);
            }
        });
    }

    private String addTemplatedParam(String name) {
        return String.format("{%s}", name);
    }
}

