/*
 * Decompiled with CFR 0.152.
 */
package feign.graphql;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import feign.graphql.GraphqlContract;
import feign.graphql.GraphqlErrorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Iterator;

public class GraphqlDecoder
implements Decoder {
    private final ObjectMapper mapper;
    private final Decoder delegate;

    public GraphqlDecoder() {
        this(new ObjectMapper(), null);
    }

    public GraphqlDecoder(ObjectMapper mapper) {
        this(mapper, null);
    }

    public GraphqlDecoder(Decoder delegate) {
        this(new ObjectMapper(), delegate);
    }

    public GraphqlDecoder(ObjectMapper mapper, Decoder delegate) {
        this.mapper = mapper;
        this.delegate = delegate;
    }

    public Object decode(Response response, Type type) throws IOException {
        JsonNode root;
        JsonNode errorsNode;
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(response.charset());
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader, 1);
        }
        if (!(errorsNode = (root = this.mapper.readTree(reader)).path("errors")).isMissingNode() && errorsNode.isArray() && !errorsNode.isEmpty()) {
            String operationField = this.resolveOperationField(root, response);
            throw new GraphqlErrorException(response.status(), operationField, errorsNode.toString(), response.request());
        }
        JsonNode dataNode = root.path("data");
        if (dataNode.isMissingNode() || dataNode.isNull() || !dataNode.isObject()) {
            return Util.emptyValueOf((Type)type);
        }
        Iterator fieldNames = dataNode.fieldNames();
        if (!fieldNames.hasNext()) {
            return Util.emptyValueOf((Type)type);
        }
        String firstField = (String)fieldNames.next();
        JsonNode operationData = dataNode.get(firstField);
        if (operationData == null || operationData.isNull()) {
            return Util.emptyValueOf((Type)type);
        }
        if (this.delegate != null) {
            byte[] dataBytes = this.mapper.writeValueAsBytes((Object)operationData);
            Response dataResponse = Response.builder().status(response.status()).reason(response.reason()).headers(response.headers()).request(response.request()).body(dataBytes).build();
            return this.delegate.decode(dataResponse, type);
        }
        return this.mapper.readValue(this.mapper.treeAsTokens((TreeNode)operationData), this.mapper.constructType(type));
    }

    private String resolveOperationField(JsonNode root, Response response) {
        Iterator names;
        JsonNode dataNode = root.path("data");
        if (!dataNode.isMissingNode() && dataNode.isObject() && (names = dataNode.fieldNames()).hasNext()) {
            return (String)names.next();
        }
        if (response.request() != null && response.request().body() != null) {
            try {
                JsonNode requestBody = this.mapper.readTree(response.request().body());
                String query = requestBody.path("query").asText(null);
                if (query != null) {
                    return GraphqlContract.extractOperationField(query);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "unknown";
    }
}

