/*
 * Decompiled with CFR 0.152.
 */
package feign.googlehttpclient;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import feign.Client;
import feign.Request;
import feign.Response;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GoogleHttpClient
implements Client {
    private final HttpTransport transport;
    private final HttpRequestFactory requestFactory;

    public GoogleHttpClient() {
        this((HttpTransport)new NetHttpTransport());
    }

    public GoogleHttpClient(HttpTransport transport) {
        this.transport = transport;
        this.requestFactory = transport.createRequestFactory();
    }

    public final Response execute(Request inputRequest, Request.Options options) throws IOException {
        HttpRequest request = this.convertRequest(inputRequest, options);
        HttpResponse response = request.execute();
        return this.convertResponse(inputRequest, response);
    }

    private final HttpRequest convertRequest(Request inputRequest, Request.Options options) throws IOException {
        ByteArrayContent content = null;
        if (inputRequest.length() > 0) {
            Collection contentTypeValues = (Collection)inputRequest.headers().get("Content-Type");
            String contentType = null;
            contentType = contentTypeValues != null && contentTypeValues.size() > 0 ? (String)contentTypeValues.iterator().next() : "application/octet-stream";
            content = new ByteArrayContent(contentType, inputRequest.body());
        }
        HttpRequest request = this.requestFactory.buildRequest(inputRequest.httpMethod().name(), new GenericUrl(inputRequest.url()), content);
        HttpHeaders headers = new HttpHeaders();
        for (Map.Entry header : inputRequest.headers().entrySet()) {
            headers.set((String)header.getKey(), header.getValue());
        }
        if (inputRequest.headers().get("Accept") == null) {
            headers.setAccept("*/*");
        }
        request.setHeaders(headers);
        request.setReadTimeout(options.readTimeoutMillis()).setConnectTimeout(options.connectTimeoutMillis()).setFollowRedirects(options.isFollowRedirects()).setThrowExceptionOnExecuteError(false);
        return request;
    }

    private final Response convertResponse(Request inputRequest, HttpResponse inputResponse) throws IOException {
        HttpHeaders headers = inputResponse.getHeaders();
        Integer contentLength = null;
        if (headers.getContentLength() != null && headers.getContentLength() <= Integer.MAX_VALUE) {
            contentLength = inputResponse.getHeaders().getContentLength().intValue();
        }
        return Response.builder().body(inputResponse.getContent(), contentLength).status(inputResponse.getStatusCode()).reason(inputResponse.getStatusMessage()).headers(this.toMap(inputResponse.getHeaders())).request(inputRequest).build();
    }

    private final Map<String, Collection<String>> toMap(HttpHeaders headers) {
        HashMap<String, Collection<String>> map = new HashMap<String, Collection<String>>();
        for (String header : headers.keySet()) {
            map.put(header, headers.getHeaderStringValues(header));
        }
        return map;
    }
}

