/*
 * Decompiled with CFR 0.152.
 */
package feign.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import feign.FeignException;
import feign.Response;
import feign.Util;
import feign.codec.Decoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;

public class Fastjson2Decoder
implements Decoder {
    private final JSONReader.Feature[] features;

    public Fastjson2Decoder() {
        this(new JSONReader.Feature[0]);
    }

    public Fastjson2Decoder(JSONReader.Feature[] features) {
        this.features = features;
    }

    public Object decode(Response response, Type type) throws IOException, FeignException {
        if (response.status() == 404 || response.status() == 204) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        Reader reader = response.body().asReader(response.charset());
        try {
            Object object = JSON.parseObject((Reader)reader, (Type)type, (JSONReader.Feature[])this.features);
            return object;
        }
        catch (JSONException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                throw (IOException)IOException.class.cast(e.getCause());
            }
            throw e;
        }
        finally {
            Util.ensureClosed((Closeable)reader);
        }
    }
}

