/*
 * Decompiled with CFR 0.152.
 */
package example.github;

import feign.Feign;
import feign.Logger;
import feign.Param;
import feign.RequestLine;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.gson.GsonDecoder;
import feign.gson.GsonEncoder;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.stream.Collectors;

public class GitHubExample {
    private static final String GITHUB_TOKEN = "GITHUB_TOKEN";

    public static void main(String ... args) {
        GitHub github = GitHub.connect();
        System.out.println("Let's fetch and print a list of the contributors to this org.");
        List<String> contributors = github.contributors("openfeign");
        for (String contributor : contributors) {
            System.out.println(contributor);
        }
        System.out.println("Now, let's cause an error.");
        try {
            github.contributors("openfeign", "some-unknown-project");
        }
        catch (GitHubClientError e) {
            System.out.println(e.getMessage());
        }
        System.out.println("Now, try to create an issue - which will also cause an error.");
        try {
            GitHub.Issue issue = new GitHub.Issue();
            issue.title = "The title";
            issue.body = "Some Text";
            github.createIssue(issue, "OpenFeign", "SomeRepo");
        }
        catch (GitHubClientError e) {
            System.out.println(e.getMessage());
        }
    }

    static class GitHubErrorDecoder
    implements ErrorDecoder {
        final Decoder decoder;
        final ErrorDecoder defaultDecoder = new ErrorDecoder.Default();

        GitHubErrorDecoder(Decoder decoder) {
            this.decoder = decoder;
        }

        @Override
        public Exception decode(String methodKey, Response response) {
            try {
                response = response.toBuilder().status(200).build();
                return (Exception)this.decoder.decode(response, (Type)((Object)GitHubClientError.class));
            }
            catch (IOException fallbackToDefault) {
                return this.defaultDecoder.decode(methodKey, response);
            }
        }
    }

    static class GitHubClientError
    extends RuntimeException {
        private String message;

        GitHubClientError() {
        }

        @Override
        public String getMessage() {
            return this.message;
        }
    }

    public static interface GitHub {
        @RequestLine(value="GET /users/{username}/repos?sort=full_name")
        public List<Repository> repos(@Param(value="username") String var1);

        @RequestLine(value="GET /repos/{owner}/{repo}/contributors")
        public List<Contributor> contributors(@Param(value="owner") String var1, @Param(value="repo") String var2);

        @RequestLine(value="POST /repos/{owner}/{repo}/issues")
        public void createIssue(Issue var1, @Param(value="owner") String var2, @Param(value="repo") String var3);

        default public List<String> contributors(String owner) {
            return this.repos(owner).stream().flatMap(repo -> this.contributors(owner, repo.name).stream()).map(c -> c.login).distinct().collect(Collectors.toList());
        }

        public static GitHub connect() {
            GsonDecoder decoder = new GsonDecoder();
            GsonEncoder encoder = new GsonEncoder();
            return Feign.builder().encoder(encoder).decoder(decoder).errorDecoder(new GitHubErrorDecoder(decoder)).logger(new Logger.ErrorLogger()).logLevel(Logger.Level.BASIC).requestInterceptor(template -> {
                if (System.getenv().containsKey(GitHubExample.GITHUB_TOKEN)) {
                    System.out.println("Detected Authorization token from environment variable");
                    template.header("Authorization", "token " + System.getenv(GitHubExample.GITHUB_TOKEN));
                }
            }).target(GitHub.class, "https://api.github.com");
        }

        public static class Issue {
            String title;
            String body;
            List<String> assignees;
            int milestone;
            List<String> labels;

            Issue() {
            }
        }

        public static class Contributor {
            String login;
        }

        public static class Repository {
            String name;
        }
    }
}

