/*
 * Decompiled with CFR 0.152.
 */
package feign.kotlin;

import feign.AsyncClient;
import feign.AsyncContextSupplier;
import feign.AsyncFeign;
import feign.BaseBuilder;
import feign.Client;
import feign.Experimental;
import feign.MethodInfoResolver;
import feign.Target;
import feign.kotlin.KotlinMethodInfo;
import feign.kotlin.MethodKt;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import kotlin.coroutines.Continuation;
import kotlinx.coroutines.future.FutureKt;

@Experimental
public class CoroutineFeign<C> {
    private final AsyncFeign<C> feign;

    public static <C> CoroutineBuilder<C> builder() {
        return new CoroutineBuilder();
    }

    @Deprecated
    public static <C> CoroutineBuilder<C> coBuilder() {
        return CoroutineFeign.builder();
    }

    protected CoroutineFeign(AsyncFeign<C> feign) {
        this.feign = feign;
    }

    public <T> T newInstance(Target<T> target) {
        T instance = this.feign.newInstance(target);
        return this.wrap(target.type(), instance);
    }

    public <T> T newInstance(Target<T> target, C context) {
        T instance = this.feign.newInstance(target, context);
        return this.wrap(target.type(), instance);
    }

    private <T> T wrap(Class<T> type2, T instance) {
        return type2.cast(Proxy.newProxyInstance(type2.getClassLoader(), new Class[]{type2}, new CoroutineFeignInvocationHandler<T>(instance)));
    }

    public static class CoroutineBuilder<C>
    extends BaseBuilder<CoroutineBuilder<C>, CoroutineFeign<C>> {
        private AsyncContextSupplier<C> defaultContextSupplier = () -> null;
        private AsyncClient<C> client = new AsyncClient.Default(new Client.Default(null, null), LazyInitializedExecutorService.access$000());
        private MethodInfoResolver methodInfoResolver = KotlinMethodInfo::createInstance;

        @Deprecated
        public CoroutineBuilder<C> defaultContextSupplier(Supplier<C> supplier) {
            this.defaultContextSupplier = supplier::get;
            return this;
        }

        public CoroutineBuilder<C> client(AsyncClient<C> client) {
            this.client = client;
            return this;
        }

        public CoroutineBuilder<C> defaultContextSupplier(AsyncContextSupplier<C> supplier) {
            this.defaultContextSupplier = supplier;
            return this;
        }

        public CoroutineBuilder<C> methodInfoResolver(MethodInfoResolver methodInfoResolver) {
            this.methodInfoResolver = methodInfoResolver;
            return this;
        }

        public <T> T target(Class<T> apiType, String url) {
            return this.target(new Target.HardCodedTarget<T>(apiType, url));
        }

        public <T> T target(Class<T> apiType, String url, C context) {
            return this.target(new Target.HardCodedTarget<T>(apiType, url), context);
        }

        public <T> T target(Target<T> target) {
            return ((CoroutineFeign)this.build()).newInstance(target);
        }

        public <T> T target(Target<T> target, C context) {
            return ((CoroutineFeign)this.build()).newInstance(target, context);
        }

        @Override
        public CoroutineFeign<C> internalBuild() {
            AsyncFeign asyncFeign = (AsyncFeign)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)((AsyncFeign.AsyncBuilder)AsyncFeign.builder().logLevel(this.logLevel)).client(this.client).decoder(this.decoder)).errorDecoder(this.errorDecoder)).contract(this.contract).retryer(this.retryer)).logger(this.logger)).encoder(this.encoder)).queryMapEncoder(this.queryMapEncoder)).options(this.options)).requestInterceptors((Iterable)this.requestInterceptors).responseInterceptor(this.responseInterceptor)).invocationHandlerFactory(this.invocationHandlerFactory)).defaultContextSupplier(this.defaultContextSupplier).methodInfoResolver(this.methodInfoResolver).build();
            return new CoroutineFeign(asyncFeign);
        }
    }

    private static class CoroutineFeignInvocationHandler<T>
    implements InvocationHandler {
        private final T instance;

        CoroutineFeignInvocationHandler(T instance) {
            this.instance = instance;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if ("equals".equals(method.getName()) && method.getParameterCount() == 1) {
                try {
                    InvocationHandler otherHandler = args2.length > 0 && args2[0] != null ? Proxy.getInvocationHandler(args2[0]) : null;
                    return this.equals(otherHandler);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if ("hashCode".equals(method.getName()) && method.getParameterCount() == 0) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName()) && method.getParameterCount() == 0) {
                return this.toString();
            }
            if (MethodKt.isSuspend(method)) {
                CompletableFuture result2 = (CompletableFuture)method.invoke(this.instance, args2);
                Continuation continuation = (Continuation)args2[args2.length - 1];
                return FutureKt.await(result2, continuation);
            }
            return method.invoke(this.instance, args2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CoroutineFeignInvocationHandler) {
                CoroutineFeignInvocationHandler other = (CoroutineFeignInvocationHandler)obj;
                return this.instance.equals(other.instance);
            }
            return false;
        }

        public int hashCode() {
            return this.instance.hashCode();
        }

        public String toString() {
            return this.instance.toString();
        }
    }

    private static class LazyInitializedExecutorService {
        private static final ExecutorService instance = Executors.newCachedThreadPool(r -> {
            Thread result2 = new Thread(r);
            result2.setDaemon(true);
            return result2;
        });

        private LazyInitializedExecutorService() {
        }

        static /* synthetic */ ExecutorService access$000() {
            return instance;
        }
    }
}

