/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics5.BaseMeteredClient;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;

public class MeteredClient
extends BaseMeteredClient
implements Client {
    private final Client client;

    public MeteredClient(Client client, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        super(metricRegistry, new FeignMetricName(Client.class), metricSuppliers);
        this.client = client;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Response response;
        block10: {
            RequestTemplate template = request.requestTemplate();
            Timer.Context timer = this.createTimer(template);
            try {
                Response response2 = this.client.execute(request, options);
                this.recordSuccess(template, response2);
                response = response2;
                if (timer == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (timer != null) {
                        try {
                            timer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FeignException e) {
                    this.recordFailure(template, e);
                    throw e;
                }
                catch (IOException | RuntimeException e) {
                    this.recordFailure(template, e);
                    throw e;
                }
                catch (Exception e) {
                    this.recordFailure(template, e);
                    throw new IOException(e);
                }
            }
            timer.close();
        }
        return response;
    }
}

