/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.RequestTemplate;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MetricSuppliers;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.lang.reflect.Type;

public class MeteredEncoder
implements Encoder {
    private final Encoder encoder;
    private final MetricRegistry metricRegistry;
    private final MetricSuppliers metricSuppliers;
    private final FeignMetricName metricName;

    public MeteredEncoder(Encoder encoder, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.encoder = encoder;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Encoder.class);
    }

    public void encode(Object object, Type bodyType, RequestTemplate template) throws EncodeException {
        try (Timer.Context classTimer = this.metricRegistry.timer(this.metricName.metricName(template.methodMetadata(), template.feignTarget()), this.metricSuppliers.timers()).time();){
            this.encoder.encode(object, bodyType, template);
        }
        if (template.body() != null) {
            this.metricRegistry.histogram(this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "request_size"), this.metricSuppliers.histograms()).update(template.body().length);
        }
    }
}

