/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics5;

import feign.FeignException;
import feign.RequestTemplate;
import feign.Response;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import feign.metrics5.FeignMetricName;
import feign.metrics5.MeteredBody;
import feign.metrics5.MetricSuppliers;
import io.dropwizard.metrics5.MetricRegistry;
import io.dropwizard.metrics5.Timer;
import java.io.IOException;
import java.lang.reflect.Type;

public class MeteredDecoder
implements Decoder {
    private final Decoder decoder;
    private final MetricRegistry metricRegistry;
    private final MetricSuppliers metricSuppliers;
    private final FeignMetricName metricName;

    public MeteredDecoder(Decoder decoder, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        this.decoder = decoder;
        this.metricRegistry = metricRegistry;
        this.metricSuppliers = metricSuppliers;
        this.metricName = new FeignMetricName(Decoder.class);
    }

    public Object decode(Response response, Type type) throws IOException, DecodeException, FeignException {
        Object decoded;
        RequestTemplate template = response.request().requestTemplate();
        MeteredBody body = response.body() == null ? null : new MeteredBody(response.body());
        response = response.toBuilder().body((Response.Body)body).build();
        try (Timer.Context classTimer = this.metricRegistry.timer(this.metricName.metricName(template.methodMetadata(), template.feignTarget()), this.metricSuppliers.timers()).time();){
            decoded = this.decoder.decode(response, type);
        }
        if (body != null) {
            this.metricRegistry.histogram(this.metricName.metricName(template.methodMetadata(), template.feignTarget(), "response_size"), this.metricSuppliers.histograms()).update(body.count());
        }
        return decoded;
    }
}

