/*
 * Decompiled with CFR 0.152.
 */
package feign.metrics4;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import feign.Client;
import feign.FeignException;
import feign.Request;
import feign.RequestTemplate;
import feign.Response;
import feign.metrics4.BaseMeteredClient;
import feign.metrics4.FeignMetricName;
import feign.metrics4.MetricSuppliers;
import java.io.IOException;

public class MeteredClient
extends BaseMeteredClient
implements Client {
    private final Client client;

    public MeteredClient(Client client, MetricRegistry metricRegistry, MetricSuppliers metricSuppliers) {
        super(metricRegistry, new FeignMetricName(Client.class), metricSuppliers);
        this.client = client;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Response execute(Request request, Request.Options options) throws IOException {
        RequestTemplate template = request.requestTemplate();
        try (Timer.Context classTimer = this.createTimer(template);){
            Response response = this.client.execute(request, options);
            this.recordSuccess(template, response);
            Response response2 = response;
            return response2;
        }
        catch (FeignException e) {
            this.recordFailure(template, e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.recordFailure(template, e);
            throw e;
        }
        catch (Exception e) {
            this.recordFailure(template, e);
            throw new IOException(e);
        }
    }
}

