/*
 * Decompiled with CFR 0.152.
 */
package feign.benchmark;

import feign.Feign;
import feign.Response;
import feign.benchmark.FeignTestInterface;
import io.netty.buffer.ByteBuf;
import io.reactivex.netty.RxNetty;
import io.reactivex.netty.protocol.http.server.HttpServer;
import io.reactivex.netty.protocol.http.server.HttpServerRequest;
import io.reactivex.netty.protocol.http.server.HttpServerResponse;
import io.reactivex.netty.protocol.http.server.RequestHandler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import rx.Observable;

@Measurement(iterations=5, time=1)
@Warmup(iterations=10, time=1)
@Fork(value=3)
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class RealRequestBenchmarks {
    private static final int SERVER_PORT = 8765;
    private HttpServer<ByteBuf, ByteBuf> server;
    private OkHttpClient client;
    private FeignTestInterface okFeign;
    private Request queryRequest;

    @Setup
    public void setup() {
        this.server = RxNetty.createHttpServer(8765, new RequestHandler<ByteBuf, ByteBuf>(){

            @Override
            public Observable handle(HttpServerRequest<ByteBuf> request, HttpServerResponse<ByteBuf> response) {
                return response.flush();
            }
        });
        this.server.start();
        this.client = new OkHttpClient();
        this.client.retryOnConnectionFailure();
        this.okFeign = Feign.builder().client(new feign.okhttp.OkHttpClient(this.client)).target(FeignTestInterface.class, "http://localhost:8765");
        this.queryRequest = new Request.Builder().url("http://localhost:8765/?Action=GetUser&Version=2010-05-08&limit=1").build();
    }

    @TearDown
    public void tearDown() throws InterruptedException {
        this.server.shutdown();
    }

    @Benchmark
    public okhttp3.Response query_baseCaseUsingOkHttp() throws IOException {
        okhttp3.Response result = this.client.newCall(this.queryRequest).execute();
        result.body().close();
        return result;
    }

    @Benchmark
    public Response query_feignUsingOkHttp() {
        return this.okFeign.query();
    }
}

