/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.util;

import io.netty.channel.ChannelHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.util.EnumMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.functions.Func0;

public class LoggingHandlerFactory
implements Func0<ChannelHandler> {
    private static final ConcurrentMap<String, EnumMap<LogLevel, LoggingHandlerFactory>> factories = new ConcurrentHashMap<String, EnumMap<LogLevel, LoggingHandlerFactory>>();
    private final LoggingHandler loggingHandler;

    private LoggingHandlerFactory(String name, LogLevel wireLoggingLevel) {
        this.loggingHandler = new LoggingHandler(name, wireLoggingLevel);
    }

    public static LoggingHandler get(String name, LogLevel logLevel) {
        return LoggingHandlerFactory.getFactory((String)name, (LogLevel)logLevel).loggingHandler;
    }

    public static LoggingHandlerFactory getFactory(String name, LogLevel logLevel) {
        EnumMap<LogLevel, LoggingHandlerFactory> existing;
        EnumMap<LogLevel, LoggingHandlerFactory> f = (EnumMap<LogLevel, LoggingHandlerFactory>)factories.get(name);
        if (null == f && null != (existing = factories.putIfAbsent(name, f = LoggingHandlerFactory.newEnumMap(name)))) {
            f = existing;
        }
        return f.get((Object)logLevel);
    }

    @Override
    public ChannelHandler call() {
        return this.loggingHandler;
    }

    private static EnumMap<LogLevel, LoggingHandlerFactory> newEnumMap(String name) {
        EnumMap<LogLevel, LoggingHandlerFactory> toReturn = new EnumMap<LogLevel, LoggingHandlerFactory>(LogLevel.class);
        for (LogLevel logLevel : LogLevel.values()) {
            toReturn.put(logLevel, new LoggingHandlerFactory(name, logLevel));
        }
        return toReturn;
    }
}

