/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.channel.events;

import io.reactivex.netty.channel.events.ConnectionEventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenersHolder;
import java.util.concurrent.TimeUnit;
import rx.Subscription;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.functions.Action5;

public final class ConnectionEventPublisher<T extends ConnectionEventListener>
extends ConnectionEventListener
implements EventSource<T>,
EventPublisher {
    private final Action2<T, Long> bytesReadAction = new Action2<T, Long>(){

        @Override
        public void call(T l, Long bytesRead) {
            ((ConnectionEventListener)l).onByteRead(bytesRead);
        }
    };
    private final Action2<T, Long> bytesWrittenAction = new Action2<T, Long>(){

        @Override
        public void call(T l, Long bytesWritten) {
            ((ConnectionEventListener)l).onByteWritten(bytesWritten);
        }
    };
    private final Action1<T> flushStartAction = new Action1<T>(){

        @Override
        public void call(T l) {
            ((ConnectionEventListener)l).onFlushStart();
        }
    };
    private final Action3<T, Long, TimeUnit> flushCompleteAction = new Action3<T, Long, TimeUnit>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit) {
            ((ConnectionEventListener)l).onFlushComplete(duration, timeUnit);
        }
    };
    private final Action1<T> writeStartAction = new Action1<T>(){

        @Override
        public void call(T l) {
            ((ConnectionEventListener)l).onWriteStart();
        }
    };
    private final Action3<T, Long, TimeUnit> writeSuccessAction = new Action3<T, Long, TimeUnit>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit) {
            ((ConnectionEventListener)l).onWriteSuccess(duration, timeUnit);
        }
    };
    private final Action4<T, Long, TimeUnit, Throwable> writeFailedAction = new Action4<T, Long, TimeUnit, Throwable>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit, Throwable t) {
            ((ConnectionEventListener)l).onWriteFailed(duration, timeUnit, t);
        }
    };
    private final Action1<T> closeStartAction = new Action1<T>(){

        @Override
        public void call(T l) {
            ((ConnectionEventListener)l).onConnectionCloseStart();
        }
    };
    private final Action3<T, Long, TimeUnit> closeSuccessAction = new Action3<T, Long, TimeUnit>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit) {
            ((ConnectionEventListener)l).onConnectionCloseSuccess(duration, timeUnit);
        }
    };
    private final Action4<T, Long, TimeUnit, Throwable> closeFailedAction = new Action4<T, Long, TimeUnit, Throwable>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit, Throwable t) {
            ((ConnectionEventListener)l).onConnectionCloseFailed(duration, timeUnit, t);
        }
    };
    private final Action2<T, Object> customEventAction = new Action2<T, Object>(){

        @Override
        public void call(T l, Object event) {
            ((ConnectionEventListener)l).onCustomEvent(event);
        }
    };
    private final Action3<T, Throwable, Object> customEventErrorAction = new Action3<T, Throwable, Object>(){

        @Override
        public void call(T l, Throwable throwable, Object event) {
            ((ConnectionEventListener)l).onCustomEvent(event, throwable);
        }
    };
    private final Action4<T, Long, TimeUnit, Object> customEventDurationAction = new Action4<T, Long, TimeUnit, Object>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit, Object event) {
            ((ConnectionEventListener)l).onCustomEvent(event, duration, timeUnit);
        }
    };
    private final Action5<T, Long, TimeUnit, Throwable, Object> customEventDurationErrAction = new Action5<T, Long, TimeUnit, Throwable, Object>(){

        @Override
        public void call(T l, Long duration, TimeUnit timeUnit, Throwable throwable, Object event) {
            ((ConnectionEventListener)l).onCustomEvent(event, duration, timeUnit, throwable);
        }
    };
    private final ListenersHolder<T> listeners;

    public ConnectionEventPublisher() {
        this.listeners = new ListenersHolder();
    }

    public ConnectionEventPublisher(ConnectionEventPublisher<T> toCopy) {
        this.listeners = toCopy.listeners.copy();
    }

    @Override
    public void onByteRead(long bytesRead) {
        this.listeners.invokeListeners(this.bytesReadAction, bytesRead);
    }

    @Override
    public void onByteWritten(long bytesWritten) {
        this.listeners.invokeListeners(this.bytesWrittenAction, bytesWritten);
    }

    @Override
    public void onFlushStart() {
        this.listeners.invokeListeners(this.flushStartAction);
    }

    @Override
    public void onFlushComplete(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(this.flushCompleteAction, duration, timeUnit);
    }

    @Override
    public void onWriteStart() {
        this.listeners.invokeListeners(this.writeStartAction);
    }

    @Override
    public void onWriteSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(this.writeSuccessAction, duration, timeUnit);
    }

    @Override
    public void onWriteFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(this.writeFailedAction, duration, timeUnit, throwable);
    }

    @Override
    public void onConnectionCloseStart() {
        this.listeners.invokeListeners(this.closeStartAction);
    }

    @Override
    public void onConnectionCloseSuccess(long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(this.closeSuccessAction, duration, timeUnit);
    }

    @Override
    public void onConnectionCloseFailed(long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(this.closeFailedAction, duration, timeUnit, throwable);
    }

    @Override
    public void onCustomEvent(Object event) {
        this.listeners.invokeListeners(this.customEventAction, event);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        this.listeners.invokeListeners(this.customEventDurationAction, duration, timeUnit, event);
    }

    @Override
    public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        this.listeners.invokeListeners(this.customEventDurationErrAction, duration, timeUnit, throwable, event);
    }

    @Override
    public void onCustomEvent(Object event, Throwable throwable) {
        this.listeners.invokeListeners(this.customEventErrorAction, throwable, event);
    }

    @Override
    public Subscription subscribe(T listener) {
        return this.listeners.subscribe(listener);
    }

    @Override
    public boolean publishingEnabled() {
        return this.listeners.publishingEnabled();
    }

    public ConnectionEventPublisher<T> copy() {
        return new ConnectionEventPublisher<T>(this);
    }

    ListenersHolder<T> getListeners() {
        return this.listeners;
    }
}

