/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.spectator.internal;

import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Registry;
import com.netflix.spectator.api.histogram.PercentileTimer;
import io.reactivex.netty.spectator.internal.SpectatorUtils;
import java.util.concurrent.TimeUnit;

public class EventMetric {
    private final Counter start;
    private final PercentileTimer startLatency;
    private final Counter success;
    private final PercentileTimer successLatency;
    private final Counter failed;
    private final PercentileTimer failureLatency;

    public EventMetric(Registry registry, String name, String monitorId, String ... tags) {
        this.start = SpectatorUtils.newCounter(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "count", "state", "start"));
        this.startLatency = SpectatorUtils.newPercentileTimer(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "latency", "state", "start"));
        this.success = SpectatorUtils.newCounter(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "count", "state", "success"));
        this.successLatency = SpectatorUtils.newPercentileTimer(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "latency", "state", "success"));
        this.failed = SpectatorUtils.newCounter(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "count", "state", "failed"));
        this.failureLatency = SpectatorUtils.newPercentileTimer(registry, name, monitorId, SpectatorUtils.mergeTags(tags, "rtype", "latency", "state", "failed"));
    }

    public void start() {
        this.start.increment();
    }

    public void start(long duration, TimeUnit timeUnit) {
        this.start.increment();
        this.startLatency.record(duration, timeUnit);
    }

    public void success() {
        this.success.increment();
    }

    public void success(long duration, TimeUnit timeUnit) {
        this.success.increment();
        this.successLatency.record(duration, timeUnit);
    }

    public void failure() {
        this.failed.increment();
    }

    public void failure(long duration, TimeUnit timeUnit) {
        this.failed.increment();
        this.failureLatency.record(duration, timeUnit);
    }
}

