/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.internal;

import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.HostConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.functions.Action1;

public class SingleHostConnectionProvider<W, R>
implements ConnectionProvider<W, R> {
    private static final Logger logger = LoggerFactory.getLogger(SingleHostConnectionProvider.class);
    private volatile ConnectionProvider<W, R> provider;

    public SingleHostConnectionProvider(Observable<HostConnector<W, R>> connectors) {
        connectors.toSingle().subscribe(new Action1<HostConnector<W, R>>(){

            @Override
            public void call(HostConnector<W, R> connector) {
                SingleHostConnectionProvider.this.provider = connector.getConnectionProvider();
            }
        }, new Action1<Throwable>(){

            @Override
            public void call(Throwable t) {
                logger.error("Failed while fetching a host connector from a scalar host source", t);
            }
        });
    }

    @Override
    public Observable<Connection<R, W>> newConnectionRequest() {
        return null != this.provider ? this.provider.newConnectionRequest() : Observable.error(new IllegalStateException("No hosts available."));
    }
}

