/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.observers.Subscribers;

public final class OnSubscribeUsing<T, Resource>
implements Observable.OnSubscribe<T> {
    private final Func0<Resource> resourceFactory;
    private final Func1<? super Resource, ? extends Observable<? extends T>> observableFactory;
    private final Action1<? super Resource> dispose;
    private final boolean disposeEagerly;

    public OnSubscribeUsing(Func0<Resource> resourceFactory, Func1<? super Resource, ? extends Observable<? extends T>> observableFactory, Action1<? super Resource> dispose, boolean disposeEagerly) {
        this.resourceFactory = resourceFactory;
        this.observableFactory = observableFactory;
        this.dispose = dispose;
        this.disposeEagerly = disposeEagerly;
    }

    @Override
    public void call(Subscriber<? super T> subscriber) {
        block5: {
            try {
                Resource resource = this.resourceFactory.call();
                DisposeAction disposeOnceOnly = new DisposeAction(this.dispose, resource);
                subscriber.add(disposeOnceOnly);
                Observable<? super T> source = this.observableFactory.call(resource);
                Observable<Object> observable = this.disposeEagerly ? source.doOnTerminate(disposeOnceOnly) : source;
                try {
                    observable.unsafeSubscribe(Subscribers.wrap(subscriber));
                }
                catch (Throwable e) {
                    Throwable disposeError = this.disposeEagerlyIfRequested(disposeOnceOnly);
                    if (disposeError != null) {
                        subscriber.onError(new CompositeException(Arrays.asList(e, disposeError)));
                        break block5;
                    }
                    subscriber.onError(e);
                }
            }
            catch (Throwable e) {
                subscriber.onError(e);
            }
        }
    }

    private Throwable disposeEagerlyIfRequested(Action0 disposeOnceOnly) {
        if (this.disposeEagerly) {
            try {
                disposeOnceOnly.call();
                return null;
            }
            catch (Throwable e) {
                return e;
            }
        }
        return null;
    }

    private static final class DisposeAction<Resource>
    extends AtomicBoolean
    implements Action0,
    Subscription {
        private static final long serialVersionUID = 4262875056400218316L;
        private Action1<? super Resource> dispose;
        private Resource resource;

        private DisposeAction(Action1<? super Resource> dispose, Resource resource) {
            this.dispose = dispose;
            this.resource = resource;
            this.lazySet(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void call() {
            if (this.compareAndSet(false, true)) {
                try {
                    this.dispose.call(this.resource);
                }
                finally {
                    this.resource = null;
                    this.dispose = null;
                }
            }
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get();
        }

        @Override
        public void unsubscribe() {
            this.call();
        }
    }
}

