/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.operators.BackpressureUtils;

public final class OnSubscribeFromIterable<T>
implements Observable.OnSubscribe<T> {
    final Iterable<? extends T> is;

    public OnSubscribeFromIterable(Iterable<? extends T> iterable) {
        if (iterable == null) {
            throw new NullPointerException("iterable must not be null");
        }
        this.is = iterable;
    }

    @Override
    public void call(Subscriber<? super T> o) {
        Iterator<T> it = this.is.iterator();
        if (!it.hasNext() && !o.isUnsubscribed()) {
            o.onCompleted();
        } else {
            o.setProducer(new IterableProducer(o, it));
        }
    }

    private static final class IterableProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -8730475647105475802L;
        private final Subscriber<? super T> o;
        private final Iterator<? extends T> it;

        private IterableProducer(Subscriber<? super T> o, Iterator<? extends T> it) {
            this.o = o;
            this.it = it;
        }

        @Override
        public void request(long n) {
            if (this.get() == Long.MAX_VALUE) {
                return;
            }
            if (n == Long.MAX_VALUE && this.compareAndSet(0L, Long.MAX_VALUE)) {
                this.fastpath();
            } else if (n > 0L && BackpressureUtils.getAndAddRequest(this, n) == 0L) {
                this.slowpath(n);
            }
        }

        void slowpath(long n) {
            Subscriber<T> o = this.o;
            Iterator<T> it = this.it;
            long r = n;
            block0: do {
                long numToEmit = r;
                while (true) {
                    if (o.isUnsubscribed()) {
                        return;
                    }
                    if (!it.hasNext()) break;
                    if (--numToEmit < 0L) continue block0;
                    o.onNext(it.next());
                }
                if (!o.isUnsubscribed()) {
                    o.onCompleted();
                    return;
                }
                return;
            } while ((r = this.addAndGet(-r)) != 0L);
        }

        void fastpath() {
            Subscriber<T> o = this.o;
            Iterator<T> it = this.it;
            while (true) {
                if (o.isUnsubscribed()) {
                    return;
                }
                if (!it.hasNext()) break;
                o.onNext(it.next());
            }
            if (!o.isUnsubscribed()) {
                o.onCompleted();
                return;
            }
        }
    }
}

