/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.ByteString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.charset.Charset;
import java.text.ParseException;

public final class ByteStringValueConverter
implements ValueConverter<ByteString> {
    public static final ByteStringValueConverter INSTANCE = new ByteStringValueConverter();
    private static final Charset DEFAULT_CHARSET = CharsetUtil.UTF_8;

    private ByteStringValueConverter() {
    }

    @Override
    public ByteString convertObject(Object value) {
        if (value instanceof ByteString) {
            return (ByteString)value;
        }
        if (value instanceof CharSequence) {
            return new ByteString((CharSequence)value, DEFAULT_CHARSET);
        }
        return new ByteString(value.toString(), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertInt(int value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertLong(long value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertDouble(double value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertChar(char value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertBoolean(boolean value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public ByteString convertFloat(float value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public int convertToInt(ByteString value) {
        return value.parseAsciiInt();
    }

    @Override
    public long convertToLong(ByteString value) {
        return value.parseAsciiLong();
    }

    @Override
    public ByteString convertTimeMillis(long value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public long convertToTimeMillis(ByteString value) {
        try {
            return DefaultHeaders.HeaderDateFormat.get().parse(value.toString());
        }
        catch (ParseException e) {
            PlatformDependent.throwException(e);
            return 0L;
        }
    }

    @Override
    public double convertToDouble(ByteString value) {
        return value.parseAsciiDouble();
    }

    @Override
    public char convertToChar(ByteString value) {
        return value.parseChar();
    }

    @Override
    public boolean convertToBoolean(ByteString value) {
        return value.byteAt(0) != 0;
    }

    @Override
    public float convertToFloat(ByteString value) {
        return value.parseAsciiFloat();
    }

    @Override
    public ByteString convertShort(short value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public short convertToShort(ByteString value) {
        return value.parseAsciiShort();
    }

    @Override
    public ByteString convertByte(byte value) {
        return new ByteString(String.valueOf(value), DEFAULT_CHARSET);
    }

    @Override
    public byte convertToByte(ByteString value) {
        return value.byteAt(0);
    }
}

