/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Util;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;

public final class Request {
    private final HttpMethod httpMethod;
    private final String url;
    private final Map<String, Collection<String>> headers;
    private final byte[] body;
    private final Charset charset;

    public static Request create(String method, String url, Map<String, Collection<String>> headers, byte[] body, Charset charset) {
        Util.checkNotNull(method, "httpMethod of %s", method);
        HttpMethod httpMethod = HttpMethod.valueOf(method.toUpperCase());
        return Request.create(httpMethod, url, headers, body, charset);
    }

    public static Request create(HttpMethod httpMethod, String url, Map<String, Collection<String>> headers, byte[] body, Charset charset) {
        return new Request(httpMethod, url, headers, body, charset);
    }

    Request(HttpMethod method, String url, Map<String, Collection<String>> headers, byte[] body, Charset charset) {
        this.httpMethod = Util.checkNotNull(method, "httpMethod of %s", method.name());
        this.url = Util.checkNotNull(url, "url", new Object[0]);
        this.headers = Util.checkNotNull(headers, "headers of %s %s", new Object[]{method, url});
        this.body = body;
        this.charset = charset;
    }

    public String method() {
        return this.httpMethod.name();
    }

    public HttpMethod httpMethod() {
        return this.httpMethod;
    }

    public String url() {
        return this.url;
    }

    public Map<String, Collection<String>> headers() {
        return this.headers;
    }

    public Charset charset() {
        return this.charset;
    }

    public byte[] body() {
        return this.body;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.httpMethod).append(' ').append(this.url).append(" HTTP/1.1\n");
        for (String field : this.headers.keySet()) {
            for (String value : Util.valuesOrEmpty(this.headers, field)) {
                builder.append(field).append(": ").append(value).append('\n');
            }
        }
        if (this.body != null) {
            builder.append('\n').append(this.charset != null ? new String(this.body, this.charset) : "Binary data");
        }
        return builder.toString();
    }

    public static class Options {
        private final int connectTimeoutMillis;
        private final int readTimeoutMillis;
        private final boolean followRedirects;

        public Options(int connectTimeoutMillis, int readTimeoutMillis, boolean followRedirects) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            this.readTimeoutMillis = readTimeoutMillis;
            this.followRedirects = followRedirects;
        }

        public Options(int connectTimeoutMillis, int readTimeoutMillis) {
            this(connectTimeoutMillis, readTimeoutMillis, true);
        }

        public Options() {
            this(10000, 60000);
        }

        public int connectTimeoutMillis() {
            return this.connectTimeoutMillis;
        }

        public int readTimeoutMillis() {
            return this.readTimeoutMillis;
        }

        public boolean isFollowRedirects() {
            return this.followRedirects;
        }
    }

    public static enum HttpMethod {
        GET,
        HEAD,
        POST,
        PUT,
        DELETE,
        CONNECT,
        OPTIONS,
        TRACE,
        PATCH;

    }
}

