package com.redhat.mercury.savingsaccount.v10.client;

import javax.enterprise.context.ApplicationScoped;

import com.redhat.mercury.savingsaccount.v10.api.bqaccountsweepservice.BQAccountSweepService;
import com.redhat.mercury.savingsaccount.v10.api.bqdepositsandwithdrawalsservice.BQDepositsandWithdrawalsService;
import com.redhat.mercury.savingsaccount.v10.api.bqinterestservice.BQInterestService;
import com.redhat.mercury.savingsaccount.v10.api.bqservicefeesservice.BQServiceFeesService;
import com.redhat.mercury.savingsaccount.v10.api.bqaccountlienservice.BQAccountLienService;
import com.redhat.mercury.savingsaccount.v10.api.bqpaymentsservice.BQPaymentsService;
import com.redhat.mercury.savingsaccount.v10.api.crsavingsaccountfacilityservice.CRSavingsAccountFacilityService;
import com.redhat.mercury.savingsaccount.v10.api.bqissueddeviceservice.BQIssuedDeviceService;
import io.quarkus.grpc.GrpcClient;
import lombok.Getter;

@ApplicationScoped
@Getter
public class SavingsAccountClient {

    @GrpcClient("savings-account-bq-account-sweep")
    BQAccountSweepService bQAccountSweepService;
        
    @GrpcClient("savings-account-bq-depositsand-withdrawals")
    BQDepositsandWithdrawalsService bQDepositsandWithdrawalsService;
        
    @GrpcClient("savings-account-bq-interest")
    BQInterestService bQInterestService;
        
    @GrpcClient("savings-account-bq-fees")
    BQServiceFeesService bQServiceFeesService;
        
    @GrpcClient("savings-account-bq-account-lien")
    BQAccountLienService bQAccountLienService;
        
    @GrpcClient("savings-account-bq-payments")
    BQPaymentsService bQPaymentsService;
        
    @GrpcClient("savings-account-cr-savings-account-facility")
    CRSavingsAccountFacilityService cRSavingsAccountFacilityService;
        
    @GrpcClient("savings-account-bq-issued-device")
    BQIssuedDeviceService bQIssuedDeviceService;
        
}