/*
 * Decompiled with CFR 0.152.
 */
package com.github.barteksc.pdfviewer;

import android.graphics.RectF;
import com.github.barteksc.pdfviewer.PDFView;
import com.github.barteksc.pdfviewer.util.Constants;
import com.github.barteksc.pdfviewer.util.MathUtils;
import com.github.barteksc.pdfviewer.util.Util;
import com.shockwave.pdfium.util.SizeF;
import java.util.LinkedList;
import java.util.List;

class PagesLoader {
    private PDFView pdfView;
    private int cacheOrder;
    private float xOffset;
    private float yOffset;
    private float pageRelativePartWidth;
    private float pageRelativePartHeight;
    private float partRenderWidth;
    private float partRenderHeight;
    private final RectF thumbnailRect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
    private final int preloadOffset;

    PagesLoader(PDFView pdfView) {
        this.pdfView = pdfView;
        this.preloadOffset = Util.getDP(pdfView.getContext(), Constants.PRELOAD_OFFSET);
    }

    private void getPageColsRows(GridSize grid, int pageIndex) {
        SizeF size = this.pdfView.pdfFile.getPageSize(pageIndex);
        float ratioX = 1.0f / size.getWidth();
        float ratioY = 1.0f / size.getHeight();
        float partHeight = Constants.PART_SIZE * ratioY / this.pdfView.getZoom();
        float partWidth = Constants.PART_SIZE * ratioX / this.pdfView.getZoom();
        grid.rows = MathUtils.ceil(1.0f / partHeight);
        grid.cols = MathUtils.ceil(1.0f / partWidth);
    }

    private void calculatePartSize(GridSize grid) {
        this.pageRelativePartWidth = 1.0f / (float)grid.cols;
        this.pageRelativePartHeight = 1.0f / (float)grid.rows;
        this.partRenderWidth = Constants.PART_SIZE / this.pageRelativePartWidth;
        this.partRenderHeight = Constants.PART_SIZE / this.pageRelativePartHeight;
    }

    private List<RenderRange> getRenderRangeList(float firstXOffset, float firstYOffset, float lastXOffset, float lastYOffset) {
        float fixedFirstXOffset = -MathUtils.max(firstXOffset, 0.0f);
        float fixedFirstYOffset = -MathUtils.max(firstYOffset, 0.0f);
        float fixedLastXOffset = -MathUtils.max(lastXOffset, 0.0f);
        float fixedLastYOffset = -MathUtils.max(lastYOffset, 0.0f);
        float offsetFirst = this.pdfView.isSwipeVertical() ? fixedFirstYOffset : fixedFirstXOffset;
        float offsetLast = this.pdfView.isSwipeVertical() ? fixedLastYOffset : fixedLastXOffset;
        int firstPage = this.pdfView.pdfFile.getPageAtOffset(offsetFirst, this.pdfView.getZoom());
        int lastPage = this.pdfView.pdfFile.getPageAtOffset(offsetLast, this.pdfView.getZoom());
        int pageCount = lastPage - firstPage + 1;
        LinkedList<RenderRange> renderRanges = new LinkedList<RenderRange>();
        for (int page = firstPage; page <= lastPage; ++page) {
            float pageLastYOffset;
            float pageLastXOffset;
            float pageFirstYOffset;
            float pageFirstXOffset;
            RenderRange range = new RenderRange();
            range.page = page;
            if (page == firstPage) {
                pageFirstXOffset = fixedFirstXOffset;
                pageFirstYOffset = fixedFirstYOffset;
                if (pageCount == 1) {
                    pageLastXOffset = fixedLastXOffset;
                    pageLastYOffset = fixedLastYOffset;
                } else {
                    float pageOffset = this.pdfView.pdfFile.getPageOffset(page, this.pdfView.getZoom());
                    SizeF pageSize = this.pdfView.pdfFile.getScaledPageSize(page, this.pdfView.getZoom());
                    if (this.pdfView.isSwipeVertical()) {
                        pageLastXOffset = fixedLastXOffset;
                        pageLastYOffset = pageOffset + pageSize.getHeight();
                    } else {
                        pageLastYOffset = fixedLastYOffset;
                        pageLastXOffset = pageOffset + pageSize.getWidth();
                    }
                }
            } else if (page == lastPage) {
                float pageOffset = this.pdfView.pdfFile.getPageOffset(page, this.pdfView.getZoom());
                if (this.pdfView.isSwipeVertical()) {
                    pageFirstXOffset = fixedFirstXOffset;
                    pageFirstYOffset = pageOffset;
                } else {
                    pageFirstYOffset = fixedFirstYOffset;
                    pageFirstXOffset = pageOffset;
                }
                pageLastXOffset = fixedLastXOffset;
                pageLastYOffset = fixedLastYOffset;
            } else {
                float pageOffset = this.pdfView.pdfFile.getPageOffset(page, this.pdfView.getZoom());
                SizeF pageSize = this.pdfView.pdfFile.getScaledPageSize(page, this.pdfView.getZoom());
                if (this.pdfView.isSwipeVertical()) {
                    pageFirstXOffset = fixedFirstXOffset;
                    pageFirstYOffset = pageOffset;
                    pageLastXOffset = fixedLastXOffset;
                    pageLastYOffset = pageOffset + pageSize.getHeight();
                } else {
                    pageFirstXOffset = pageOffset;
                    pageFirstYOffset = fixedFirstYOffset;
                    pageLastXOffset = pageOffset + pageSize.getWidth();
                    pageLastYOffset = fixedLastYOffset;
                }
            }
            this.getPageColsRows(range.gridSize, range.page);
            SizeF scaledPageSize = this.pdfView.pdfFile.getScaledPageSize(range.page, this.pdfView.getZoom());
            float rowHeight = scaledPageSize.getHeight() / (float)range.gridSize.rows;
            float colWidth = scaledPageSize.getWidth() / (float)range.gridSize.cols;
            float secondaryOffset = this.pdfView.pdfFile.getSecondaryPageOffset(page, this.pdfView.getZoom());
            if (this.pdfView.isSwipeVertical()) {
                range.leftTop.row = MathUtils.floor(Math.abs(pageFirstYOffset - this.pdfView.pdfFile.getPageOffset(range.page, this.pdfView.getZoom())) / rowHeight);
                range.leftTop.col = MathUtils.floor(MathUtils.min(pageFirstXOffset - secondaryOffset, 0.0f) / colWidth);
                range.rightBottom.row = MathUtils.ceil(Math.abs(pageLastYOffset - this.pdfView.pdfFile.getPageOffset(range.page, this.pdfView.getZoom())) / rowHeight);
                range.rightBottom.col = MathUtils.floor(MathUtils.min(pageLastXOffset - secondaryOffset, 0.0f) / colWidth);
            } else {
                range.leftTop.col = MathUtils.floor(Math.abs(pageFirstXOffset - this.pdfView.pdfFile.getPageOffset(range.page, this.pdfView.getZoom())) / colWidth);
                range.leftTop.row = MathUtils.floor(MathUtils.min(pageFirstYOffset - secondaryOffset, 0.0f) / rowHeight);
                range.rightBottom.col = MathUtils.floor(Math.abs(pageLastXOffset - this.pdfView.pdfFile.getPageOffset(range.page, this.pdfView.getZoom())) / colWidth);
                range.rightBottom.row = MathUtils.floor(MathUtils.min(pageLastYOffset - secondaryOffset, 0.0f) / rowHeight);
            }
            renderRanges.add(range);
        }
        return renderRanges;
    }

    private void loadVisible() {
        int parts = 0;
        float scaledPreloadOffset = this.preloadOffset;
        float firstXOffset = -this.xOffset + scaledPreloadOffset;
        float lastXOffset = -this.xOffset - (float)this.pdfView.getWidth() - scaledPreloadOffset;
        float firstYOffset = -this.yOffset + scaledPreloadOffset;
        float lastYOffset = -this.yOffset - (float)this.pdfView.getHeight() - scaledPreloadOffset;
        List<RenderRange> rangeList = this.getRenderRangeList(firstXOffset, firstYOffset, lastXOffset, lastYOffset);
        for (RenderRange range : rangeList) {
            this.loadThumbnail(range.page);
        }
        for (RenderRange range : rangeList) {
            this.calculatePartSize(range.gridSize);
            if ((parts += this.loadPage(range.page, range.leftTop.row, range.rightBottom.row, range.leftTop.col, range.rightBottom.col, Constants.Cache.CACHE_SIZE - parts)) < Constants.Cache.CACHE_SIZE) continue;
            break;
        }
    }

    private int loadPage(int page, int firstRow, int lastRow, int firstCol, int lastCol, int nbOfPartsLoadable) {
        int loaded = 0;
        for (int row = firstRow; row <= lastRow; ++row) {
            for (int col = firstCol; col <= lastCol; ++col) {
                if (this.loadCell(page, row, col, this.pageRelativePartWidth, this.pageRelativePartHeight)) {
                    ++loaded;
                }
                if (loaded < nbOfPartsLoadable) continue;
                return loaded;
            }
        }
        return loaded;
    }

    private boolean loadCell(int page, int row, int col, float pageRelativePartWidth, float pageRelativePartHeight) {
        float relX = pageRelativePartWidth * (float)col;
        float relY = pageRelativePartHeight * (float)row;
        float relWidth = pageRelativePartWidth;
        float relHeight = pageRelativePartHeight;
        float renderWidth = this.partRenderWidth;
        float renderHeight = this.partRenderHeight;
        if (relX + relWidth > 1.0f) {
            relWidth = 1.0f - relX;
        }
        if (relY + relHeight > 1.0f) {
            relHeight = 1.0f - relY;
        }
        renderWidth *= relWidth;
        renderHeight *= relHeight;
        RectF pageRelativeBounds = new RectF(relX, relY, relX + relWidth, relY + relHeight);
        if (renderWidth > 0.0f && renderHeight > 0.0f) {
            if (!this.pdfView.cacheManager.upPartIfContained(page, pageRelativeBounds, this.cacheOrder)) {
                this.pdfView.renderingHandler.addRenderingTask(page, renderWidth, renderHeight, pageRelativeBounds, false, this.cacheOrder, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
            }
            ++this.cacheOrder;
            return true;
        }
        return false;
    }

    private void loadThumbnail(int page) {
        SizeF pageSize = this.pdfView.pdfFile.getPageSize(page);
        float thumbnailWidth = pageSize.getWidth() * Constants.THUMBNAIL_RATIO;
        float thumbnailHeight = pageSize.getHeight() * Constants.THUMBNAIL_RATIO;
        if (!this.pdfView.cacheManager.containsThumbnail(page, this.thumbnailRect)) {
            this.pdfView.renderingHandler.addRenderingTask(page, thumbnailWidth, thumbnailHeight, this.thumbnailRect, true, 0, this.pdfView.isBestQuality(), this.pdfView.isAnnotationRendering());
        }
    }

    void loadPages() {
        this.cacheOrder = 1;
        this.xOffset = -MathUtils.max(this.pdfView.getCurrentXOffset(), 0.0f);
        this.yOffset = -MathUtils.max(this.pdfView.getCurrentYOffset(), 0.0f);
        this.loadVisible();
    }

    private class GridSize {
        int rows;
        int cols;

        private GridSize() {
        }

        public String toString() {
            return "GridSize{rows=" + this.rows + ", cols=" + this.cols + '}';
        }
    }

    private class RenderRange {
        int page = 0;
        GridSize gridSize;
        Holder leftTop;
        Holder rightBottom;

        RenderRange() {
            this.gridSize = new GridSize();
            this.leftTop = new Holder();
            this.rightBottom = new Holder();
        }

        public String toString() {
            return "RenderRange{page=" + this.page + ", gridSize=" + this.gridSize + ", leftTop=" + this.leftTop + ", rightBottom=" + this.rightBottom + '}';
        }
    }

    private class Holder {
        int row;
        int col;

        private Holder() {
        }

        public String toString() {
            return "Holder{row=" + this.row + ", col=" + this.col + '}';
        }
    }
}

