/*
 * Decompiled with CFR 0.152.
 */
package io.github.fragmentstack;

import android.support.annotation.IdRes;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import io.github.fragmentstack.FragmentStackBuilder;
import io.github.fragmentstack.PageManager;
import io.github.fragmentstack.listeners.FragmentPagerTransitionInterceptor;
import java.util.HashMap;
import java.util.Map;

public final class FragmentStack {
    private static Map<String, PageManager> fragmentPagerManagers = new HashMap<String, PageManager>();
    private static FragmentPagerTransitionInterceptor globalFragmentPagerTransitionInterceptor;

    public static FragmentPagerTransitionInterceptor getGlobalFragmentPagerTransitionInterceptor() {
        return globalFragmentPagerTransitionInterceptor;
    }

    private FragmentStack() {
    }

    public static FragmentStackBuilder globalConfig() {
        return new FragmentStackBuilder();
    }

    public static void build(FragmentStackBuilder builder) {
        globalFragmentPagerTransitionInterceptor = builder.globalFragmentPagerTransitionInterceptor;
    }

    public static PageManager register(AppCompatActivity activity, @IdRes int containerViewId, Fragment defaultFragment) {
        if (activity == null) {
            throw new NullPointerException("A activity is not set");
        }
        return FragmentStack.register(activity.getClass().getName(), activity.getSupportFragmentManager(), containerViewId, defaultFragment);
    }

    public static PageManager register(Fragment fragment, @IdRes int containerViewId, Fragment defaultFragment) {
        if (fragment == null) {
            throw new NullPointerException("A fragment is not set");
        }
        return FragmentStack.register(fragment.getClass().getName(), fragment.getChildFragmentManager(), containerViewId, defaultFragment);
    }

    public static PageManager register(String managerTag, FragmentManager fragmentManager, @IdRes int containerViewId, Fragment defaultFragment) {
        if (managerTag == null) {
            throw new NullPointerException("A manager tag is not set");
        }
        PageManager pageManager = new PageManager(fragmentManager, containerViewId, defaultFragment);
        fragmentPagerManagers.put(managerTag, pageManager);
        return pageManager;
    }

    public static PageManager of(AppCompatActivity activity) {
        if (activity == null) {
            throw new NullPointerException("A activity is not set");
        }
        return FragmentStack.of(activity.getClass().getName());
    }

    public static PageManager of(Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("A fragment is not set");
        }
        return FragmentStack.of(fragment.getClass().getName());
    }

    public static PageManager of(Class cls) {
        return FragmentStack.of(cls.getName());
    }

    public static PageManager of(String managerTag) {
        return fragmentPagerManagers.get(managerTag);
    }

    public static void unregister(AppCompatActivity activity) {
        if (activity == null) {
            throw new NullPointerException("A activity is not set");
        }
        FragmentStack.unregister(activity.getClass().getName());
    }

    public static void unregister(Fragment fragment) {
        if (fragment == null) {
            throw new NullPointerException("A fragment is not set");
        }
        FragmentStack.unregister(fragment.getClass().getName());
    }

    public static void unregister(String managerTag) {
        if (managerTag == null) {
            throw new NullPointerException("A manager tag is not set");
        }
        PageManager removedManager = fragmentPagerManagers.remove(managerTag);
        if (removedManager == null) {
            throw new IllegalStateException("The manager tag is not used");
        }
    }
}

