/*
 * Decompiled with CFR 0.152.
 */
package cz.jirutka.rsql.parser.ast;

import cz.jirutka.rsql.parser.ast.AbstractNode;
import cz.jirutka.rsql.parser.ast.Assert;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.RSQLVisitor;
import cz.jirutka.rsql.parser.ast.StringUtils;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
public final class ComparisonNode
extends AbstractNode {
    private final ComparisonOperator operator;
    private final String selector;
    private final List<String> arguments;

    public ComparisonNode(ComparisonOperator operator, String selector, List<String> arguments) {
        Assert.notNull(operator, "operator must not be null", new Object[0]);
        Assert.notBlank(selector, "selector must not be blank", new Object[0]);
        Assert.notEmpty(arguments, "arguments list must not be empty", new Object[0]);
        Assert.isTrue(operator.isMultiValue() || arguments.size() == 1, "operator %s expects single argument, but multiple values given", operator);
        this.operator = operator;
        this.selector = selector;
        this.arguments = new ArrayList<String>(arguments);
    }

    @Override
    public <R, A> R accept(RSQLVisitor<R, A> visitor, A param) {
        return visitor.visit(this, param);
    }

    public ComparisonOperator getOperator() {
        return this.operator;
    }

    public ComparisonNode withOperator(ComparisonOperator newOperator) {
        return new ComparisonNode(newOperator, this.selector, this.arguments);
    }

    public String getSelector() {
        return this.selector;
    }

    public ComparisonNode withSelector(String newSelector) {
        return new ComparisonNode(this.operator, newSelector, this.arguments);
    }

    public List<String> getArguments() {
        return new ArrayList<String>(this.arguments);
    }

    public ComparisonNode withArguments(List<String> newArguments) {
        return new ComparisonNode(this.operator, this.selector, newArguments);
    }

    public String toString() {
        String args = this.operator.isMultiValue() ? StringUtils.join(this.arguments, "','", "('", "')") : "'" + this.arguments.get(0) + "'";
        return this.selector + this.operator + args;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparisonNode)) {
            return false;
        }
        ComparisonNode that = (ComparisonNode)o;
        return this.arguments.equals(that.arguments) && this.operator.equals(that.operator) && this.selector.equals(that.selector);
    }

    public int hashCode() {
        int result = this.selector.hashCode();
        result = 31 * result + this.arguments.hashCode();
        result = 31 * result + this.operator.hashCode();
        return result;
    }
}

