/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.NFKDNormalizer;
import io.github.novacrypto.bip39.WordList;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;

class WordListMapNormalization
implements NFKDNormalizer {
    private final Map<CharSequence, String> normalizedMap = new HashMap<CharSequence, String>();

    WordListMapNormalization(WordList wordList) {
        for (int i = 0; i < 2048; ++i) {
            String word = wordList.getWord(i);
            String normalized = Normalizer.normalize(word, Normalizer.Form.NFKD);
            this.normalizedMap.put(word, normalized);
            this.normalizedMap.put(normalized, normalized);
            this.normalizedMap.put(Normalizer.normalize(word, Normalizer.Form.NFC), normalized);
        }
    }

    @Override
    public String normalize(CharSequence charSequence) {
        String normalized = this.normalizedMap.get(charSequence);
        if (normalized != null) {
            return normalized;
        }
        return Normalizer.normalize(charSequence, Normalizer.Form.NFKD);
    }
}

