/*
 *  BIP39 library, a Java implementation of BIP39
 *  Copyright (C) 2017-2019 Alan Evans, NovaCrypto
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 *  Original source: https://github.com/NovaCrypto/BIP39
 *  You can contact the authors via github issues.
 */

package io.github.novacrypto.bip39.wordlists;

import io.github.novacrypto.bip39.WordList;

/**
 * Source: https://github.com/bitcoin/bips/blob/master/bip-0039/french.txt
 */
public enum French implements WordList {
    INSTANCE;

    @Override
    public String getWord(final int index) {
        return words[index];
    }

    @Override
    public char getSpace() {
        return ' ';
    }

    private final static String[] words = new String[]{
            "abaisser",
            "abandon",
            "abdiquer",
            "abeille",
            "abolir",
            "aborder",
            "aboutir",
            "aboyer",
            "abrasif",
            "abreuver",
            "abriter",
            "abroger",
            "abrupt",
            "absence",
            "absolu",
            "absurde",
            "abusif",
            "abyssal",
            "académie",
            "acajou",
            "acarien",
            "accabler",
            "accepter",
            "acclamer",
            "accolade",
            "accroche",
            "accuser",
            "acerbe",
            "achat",
            "acheter",
            "aciduler",
            "acier",
            "acompte",
            "acquérir",
            "acronyme",
            "acteur",
            "actif",
            "actuel",
            "adepte",
            "adéquat",
            "adhésif",
            "adjectif",
            "adjuger",
            "admettre",
            "admirer",
            "adopter",
            "adorer",
            "adoucir",
            "adresse",
            "adroit",
            "adulte",
            "adverbe",
            "aérer",
            "aéronef",
            "affaire",
            "affecter",
            "affiche",
            "affreux",
            "affubler",
            "agacer",
            "agencer",
            "agile",
            "agiter",
            "agrafer",
            "agréable",
            "agrume",
            "aider",
            "aiguille",
            "ailier",
            "aimable",
            "aisance",
            "ajouter",
            "ajuster",
            "alarmer",
            "alchimie",
            "alerte",
            "algèbre",
            "algue",
            "aliéner",
            "aliment",
            "alléger",
            "alliage",
            "allouer",
            "allumer",
            "alourdir",
            "alpaga",
            "altesse",
            "alvéole",
            "amateur",
            "ambigu",
            "ambre",
            "aménager",
            "amertume",
            "amidon",
            "amiral",
            "amorcer",
            "amour",
            "amovible",
            "amphibie",
            "ampleur",
            "amusant",
            "analyse",
            "anaphore",
            "anarchie",
            "anatomie",
            "ancien",
            "anéantir",
            "angle",
            "angoisse",
            "anguleux",
            "animal",
            "annexer",
            "annonce",
            "annuel",
            "anodin",
            "anomalie",
            "anonyme",
            "anormal",
            "antenne",
            "antidote",
            "anxieux",
            "apaiser",
            "apéritif",
            "aplanir",
            "apologie",
            "appareil",
            "appeler",
            "apporter",
            "appuyer",
            "aquarium",
            "aqueduc",
            "arbitre",
            "arbuste",
            "ardeur",
            "ardoise",
            "argent",
            "arlequin",
            "armature",
            "armement",
            "armoire",
            "armure",
            "arpenter",
            "arracher",
            "arriver",
            "arroser",
            "arsenic",
            "artériel",
            "article",
            "aspect",
            "asphalte",
            "aspirer",
            "assaut",
            "asservir",
            "assiette",
            "associer",
            "assurer",
            "asticot",
            "astre",
            "astuce",
            "atelier",
            "atome",
            "atrium",
            "atroce",
            "attaque",
            "attentif",
            "attirer",
            "attraper",
            "aubaine",
            "auberge",
            "audace",
            "audible",
            "augurer",
            "aurore",
            "automne",
            "autruche",
            "avaler",
            "avancer",
            "avarice",
            "avenir",
            "averse",
            "aveugle",
            "aviateur",
            "avide",
            "avion",
            "aviser",
            "avoine",
            "avouer",
            "avril",
            "axial",
            "axiome",
            "badge",
            "bafouer",
            "bagage",
            "baguette",
            "baignade",
            "balancer",
            "balcon",
            "baleine",
            "balisage",
            "bambin",
            "bancaire",
            "bandage",
            "banlieue",
            "bannière",
            "banquier",
            "barbier",
            "baril",
            "baron",
            "barque",
            "barrage",
            "bassin",
            "bastion",
            "bataille",
            "bateau",
            "batterie",
            "baudrier",
            "bavarder",
            "belette",
            "bélier",
            "belote",
            "bénéfice",
            "berceau",
            "berger",
            "berline",
            "bermuda",
            "besace",
            "besogne",
            "bétail",
            "beurre",
            "biberon",
            "bicycle",
            "bidule",
            "bijou",
            "bilan",
            "bilingue",
            "billard",
            "binaire",
            "biologie",
            "biopsie",
            "biotype",
            "biscuit",
            "bison",
            "bistouri",
            "bitume",
            "bizarre",
            "blafard",
            "blague",
            "blanchir",
            "blessant",
            "blinder",
            "blond",
            "bloquer",
            "blouson",
            "bobard",
            "bobine",
            "boire",
            "boiser",
            "bolide",
            "bonbon",
            "bondir",
            "bonheur",
            "bonifier",
            "bonus",
            "bordure",
            "borne",
            "botte",
            "boucle",
            "boueux",
            "bougie",
            "boulon",
            "bouquin",
            "bourse",
            "boussole",
            "boutique",
            "boxeur",
            "branche",
            "brasier",
            "brave",
            "brebis",
            "brèche",
            "breuvage",
            "bricoler",
            "brigade",
            "brillant",
            "brioche",
            "brique",
            "brochure",
            "broder",
            "bronzer",
            "brousse",
            "broyeur",
            "brume",
            "brusque",
            "brutal",
            "bruyant",
            "buffle",
            "buisson",
            "bulletin",
            "bureau",
            "burin",
            "bustier",
            "butiner",
            "butoir",
            "buvable",
            "buvette",
            "cabanon",
            "cabine",
            "cachette",
            "cadeau",
            "cadre",
            "caféine",
            "caillou",
            "caisson",
            "calculer",
            "calepin",
            "calibre",
            "calmer",
            "calomnie",
            "calvaire",
            "camarade",
            "caméra",
            "camion",
            "campagne",
            "canal",
            "caneton",
            "canon",
            "cantine",
            "canular",
            "capable",
            "caporal",
            "caprice",
            "capsule",
            "capter",
            "capuche",
            "carabine",
            "carbone",
            "caresser",
            "caribou",
            "carnage",
            "carotte",
            "carreau",
            "carton",
            "cascade",
            "casier",
            "casque",
            "cassure",
            "causer",
            "caution",
            "cavalier",
            "caverne",
            "caviar",
            "cédille",
            "ceinture",
            "céleste",
            "cellule",
            "cendrier",
            "censurer",
            "central",
            "cercle",
            "cérébral",
            "cerise",
            "cerner",
            "cerveau",
            "cesser",
            "chagrin",
            "chaise",
            "chaleur",
            "chambre",
            "chance",
            "chapitre",
            "charbon",
            "chasseur",
            "chaton",
            "chausson",
            "chavirer",
            "chemise",
            "chenille",
            "chéquier",
            "chercher",
            "cheval",
            "chien",
            "chiffre",
            "chignon",
            "chimère",
            "chiot",
            "chlorure",
            "chocolat",
            "choisir",
            "chose",
            "chouette",
            "chrome",
            "chute",
            "cigare",
            "cigogne",
            "cimenter",
            "cinéma",
            "cintrer",
            "circuler",
            "cirer",
            "cirque",
            "citerne",
            "citoyen",
            "citron",
            "civil",
            "clairon",
            "clameur",
            "claquer",
            "classe",
            "clavier",
            "client",
            "cligner",
            "climat",
            "clivage",
            "cloche",
            "clonage",
            "cloporte",
            "cobalt",
            "cobra",
            "cocasse",
            "cocotier",
            "coder",
            "codifier",
            "coffre",
            "cogner",
            "cohésion",
            "coiffer",
            "coincer",
            "colère",
            "colibri",
            "colline",
            "colmater",
            "colonel",
            "combat",
            "comédie",
            "commande",
            "compact",
            "concert",
            "conduire",
            "confier",
            "congeler",
            "connoter",
            "consonne",
            "contact",
            "convexe",
            "copain",
            "copie",
            "corail",
            "corbeau",
            "cordage",
            "corniche",
            "corpus",
            "correct",
            "cortège",
            "cosmique",
            "costume",
            "coton",
            "coude",
            "coupure",
            "courage",
            "couteau",
            "couvrir",
            "coyote",
            "crabe",
            "crainte",
            "cravate",
            "crayon",
            "créature",
            "créditer",
            "crémeux",
            "creuser",
            "crevette",
            "cribler",
            "crier",
            "cristal",
            "critère",
            "croire",
            "croquer",
            "crotale",
            "crucial",
            "cruel",
            "crypter",
            "cubique",
            "cueillir",
            "cuillère",
            "cuisine",
            "cuivre",
            "culminer",
            "cultiver",
            "cumuler",
            "cupide",
            "curatif",
            "curseur",
            "cyanure",
            "cycle",
            "cylindre",
            "cynique",
            "daigner",
            "damier",
            "danger",
            "danseur",
            "dauphin",
            "débattre",
            "débiter",
            "déborder",
            "débrider",
            "débutant",
            "décaler",
            "décembre",
            "déchirer",
            "décider",
            "déclarer",
            "décorer",
            "décrire",
            "décupler",
            "dédale",
            "déductif",
            "déesse",
            "défensif",
            "défiler",
            "défrayer",
            "dégager",
            "dégivrer",
            "déglutir",
            "dégrafer",
            "déjeuner",
            "délice",
            "déloger",
            "demander",
            "demeurer",
            "démolir",
            "dénicher",
            "dénouer",
            "dentelle",
            "dénuder",
            "départ",
            "dépenser",
            "déphaser",
            "déplacer",
            "déposer",
            "déranger",
            "dérober",
            "désastre",
            "descente",
            "désert",
            "désigner",
            "désobéir",
            "dessiner",
            "destrier",
            "détacher",
            "détester",
            "détourer",
            "détresse",
            "devancer",
            "devenir",
            "deviner",
            "devoir",
            "diable",
            "dialogue",
            "diamant",
            "dicter",
            "différer",
            "digérer",
            "digital",
            "digne",
            "diluer",
            "dimanche",
            "diminuer",
            "dioxyde",
            "directif",
            "diriger",
            "discuter",
            "disposer",
            "dissiper",
            "distance",
            "divertir",
            "diviser",
            "docile",
            "docteur",
            "dogme",
            "doigt",
            "domaine",
            "domicile",
            "dompter",
            "donateur",
            "donjon",
            "donner",
            "dopamine",
            "dortoir",
            "dorure",
            "dosage",
            "doseur",
            "dossier",
            "dotation",
            "douanier",
            "double",
            "douceur",
            "douter",
            "doyen",
            "dragon",
            "draper",
            "dresser",
            "dribbler",
            "droiture",
            "duperie",
            "duplexe",
            "durable",
            "durcir",
            "dynastie",
            "éblouir",
            "écarter",
            "écharpe",
            "échelle",
            "éclairer",
            "éclipse",
            "éclore",
            "écluse",
            "école",
            "économie",
            "écorce",
            "écouter",
            "écraser",
            "écrémer",
            "écrivain",
            "écrou",
            "écume",
            "écureuil",
            "édifier",
            "éduquer",
            "effacer",
            "effectif",
            "effigie",
            "effort",
            "effrayer",
            "effusion",
            "égaliser",
            "égarer",
            "éjecter",
            "élaborer",
            "élargir",
            "électron",
            "élégant",
            "éléphant",
            "élève",
            "éligible",
            "élitisme",
            "éloge",
            "élucider",
            "éluder",
            "emballer",
            "embellir",
            "embryon",
            "émeraude",
            "émission",
            "emmener",
            "émotion",
            "émouvoir",
            "empereur",
            "employer",
            "emporter",
            "emprise",
            "émulsion",
            "encadrer",
            "enchère",
            "enclave",
            "encoche",
            "endiguer",
            "endosser",
            "endroit",
            "enduire",
            "énergie",
            "enfance",
            "enfermer",
            "enfouir",
            "engager",
            "engin",
            "englober",
            "énigme",
            "enjamber",
            "enjeu",
            "enlever",
            "ennemi",
            "ennuyeux",
            "enrichir",
            "enrobage",
            "enseigne",
            "entasser",
            "entendre",
            "entier",
            "entourer",
            "entraver",
            "énumérer",
            "envahir",
            "enviable",
            "envoyer",
            "enzyme",
            "éolien",
            "épaissir",
            "épargne",
            "épatant",
            "épaule",
            "épicerie",
            "épidémie",
            "épier",
            "épilogue",
            "épine",
            "épisode",
            "épitaphe",
            "époque",
            "épreuve",
            "éprouver",
            "épuisant",
            "équerre",
            "équipe",
            "ériger",
            "érosion",
            "erreur",
            "éruption",
            "escalier",
            "espadon",
            "espèce",
            "espiègle",
            "espoir",
            "esprit",
            "esquiver",
            "essayer",
            "essence",
            "essieu",
            "essorer",
            "estime",
            "estomac",
            "estrade",
            "étagère",
            "étaler",
            "étanche",
            "étatique",
            "éteindre",
            "étendoir",
            "éternel",
            "éthanol",
            "éthique",
            "ethnie",
            "étirer",
            "étoffer",
            "étoile",
            "étonnant",
            "étourdir",
            "étrange",
            "étroit",
            "étude",
            "euphorie",
            "évaluer",
            "évasion",
            "éventail",
            "évidence",
            "éviter",
            "évolutif",
            "évoquer",
            "exact",
            "exagérer",
            "exaucer",
            "exceller",
            "excitant",
            "exclusif",
            "excuse",
            "exécuter",
            "exemple",
            "exercer",
            "exhaler",
            "exhorter",
            "exigence",
            "exiler",
            "exister",
            "exotique",
            "expédier",
            "explorer",
            "exposer",
            "exprimer",
            "exquis",
            "extensif",
            "extraire",
            "exulter",
            "fable",
            "fabuleux",
            "facette",
            "facile",
            "facture",
            "faiblir",
            "falaise",
            "fameux",
            "famille",
            "farceur",
            "farfelu",
            "farine",
            "farouche",
            "fasciner",
            "fatal",
            "fatigue",
            "faucon",
            "fautif",
            "faveur",
            "favori",
            "fébrile",
            "féconder",
            "fédérer",
            "félin",
            "femme",
            "fémur",
            "fendoir",
            "féodal",
            "fermer",
            "féroce",
            "ferveur",
            "festival",
            "feuille",
            "feutre",
            "février",
            "fiasco",
            "ficeler",
            "fictif",
            "fidèle",
            "figure",
            "filature",
            "filetage",
            "filière",
            "filleul",
            "filmer",
            "filou",
            "filtrer",
            "financer",
            "finir",
            "fiole",
            "firme",
            "fissure",
            "fixer",
            "flairer",
            "flamme",
            "flasque",
            "flatteur",
            "fléau",
            "flèche",
            "fleur",
            "flexion",
            "flocon",
            "flore",
            "fluctuer",
            "fluide",
            "fluvial",
            "folie",
            "fonderie",
            "fongible",
            "fontaine",
            "forcer",
            "forgeron",
            "formuler",
            "fortune",
            "fossile",
            "foudre",
            "fougère",
            "fouiller",
            "foulure",
            "fourmi",
            "fragile",
            "fraise",
            "franchir",
            "frapper",
            "frayeur",
            "frégate",
            "freiner",
            "frelon",
            "frémir",
            "frénésie",
            "frère",
            "friable",
            "friction",
            "frisson",
            "frivole",
            "froid",
            "fromage",
            "frontal",
            "frotter",
            "fruit",
            "fugitif",
            "fuite",
            "fureur",
            "furieux",
            "furtif",
            "fusion",
            "futur",
            "gagner",
            "galaxie",
            "galerie",
            "gambader",
            "garantir",
            "gardien",
            "garnir",
            "garrigue",
            "gazelle",
            "gazon",
            "géant",
            "gélatine",
            "gélule",
            "gendarme",
            "général",
            "génie",
            "genou",
            "gentil",
            "géologie",
            "géomètre",
            "géranium",
            "germe",
            "gestuel",
            "geyser",
            "gibier",
            "gicler",
            "girafe",
            "givre",
            "glace",
            "glaive",
            "glisser",
            "globe",
            "gloire",
            "glorieux",
            "golfeur",
            "gomme",
            "gonfler",
            "gorge",
            "gorille",
            "goudron",
            "gouffre",
            "goulot",
            "goupille",
            "gourmand",
            "goutte",
            "graduel",
            "graffiti",
            "graine",
            "grand",
            "grappin",
            "gratuit",
            "gravir",
            "grenat",
            "griffure",
            "griller",
            "grimper",
            "grogner",
            "gronder",
            "grotte",
            "groupe",
            "gruger",
            "grutier",
            "gruyère",
            "guépard",
            "guerrier",
            "guide",
            "guimauve",
            "guitare",
            "gustatif",
            "gymnaste",
            "gyrostat",
            "habitude",
            "hachoir",
            "halte",
            "hameau",
            "hangar",
            "hanneton",
            "haricot",
            "harmonie",
            "harpon",
            "hasard",
            "hélium",
            "hématome",
            "herbe",
            "hérisson",
            "hermine",
            "héron",
            "hésiter",
            "heureux",
            "hiberner",
            "hibou",
            "hilarant",
            "histoire",
            "hiver",
            "homard",
            "hommage",
            "homogène",
            "honneur",
            "honorer",
            "honteux",
            "horde",
            "horizon",
            "horloge",
            "hormone",
            "horrible",
            "houleux",
            "housse",
            "hublot",
            "huileux",
            "humain",
            "humble",
            "humide",
            "humour",
            "hurler",
            "hydromel",
            "hygiène",
            "hymne",
            "hypnose",
            "idylle",
            "ignorer",
            "iguane",
            "illicite",
            "illusion",
            "image",
            "imbiber",
            "imiter",
            "immense",
            "immobile",
            "immuable",
            "impact",
            "impérial",
            "implorer",
            "imposer",
            "imprimer",
            "imputer",
            "incarner",
            "incendie",
            "incident",
            "incliner",
            "incolore",
            "indexer",
            "indice",
            "inductif",
            "inédit",
            "ineptie",
            "inexact",
            "infini",
            "infliger",
            "informer",
            "infusion",
            "ingérer",
            "inhaler",
            "inhiber",
            "injecter",
            "injure",
            "innocent",
            "inoculer",
            "inonder",
            "inscrire",
            "insecte",
            "insigne",
            "insolite",
            "inspirer",
            "instinct",
            "insulter",
            "intact",
            "intense",
            "intime",
            "intrigue",
            "intuitif",
            "inutile",
            "invasion",
            "inventer",
            "inviter",
            "invoquer",
            "ironique",
            "irradier",
            "irréel",
            "irriter",
            "isoler",
            "ivoire",
            "ivresse",
            "jaguar",
            "jaillir",
            "jambe",
            "janvier",
            "jardin",
            "jauger",
            "jaune",
            "javelot",
            "jetable",
            "jeton",
            "jeudi",
            "jeunesse",
            "joindre",
            "joncher",
            "jongler",
            "joueur",
            "jouissif",
            "journal",
            "jovial",
            "joyau",
            "joyeux",
            "jubiler",
            "jugement",
            "junior",
            "jupon",
            "juriste",
            "justice",
            "juteux",
            "juvénile",
            "kayak",
            "kimono",
            "kiosque",
            "label",
            "labial",
            "labourer",
            "lacérer",
            "lactose",
            "lagune",
            "laine",
            "laisser",
            "laitier",
            "lambeau",
            "lamelle",
            "lampe",
            "lanceur",
            "langage",
            "lanterne",
            "lapin",
            "largeur",
            "larme",
            "laurier",
            "lavabo",
            "lavoir",
            "lecture",
            "légal",
            "léger",
            "légume",
            "lessive",
            "lettre",
            "levier",
            "lexique",
            "lézard",
            "liasse",
            "libérer",
            "libre",
            "licence",
            "licorne",
            "liège",
            "lièvre",
            "ligature",
            "ligoter",
            "ligue",
            "limer",
            "limite",
            "limonade",
            "limpide",
            "linéaire",
            "lingot",
            "lionceau",
            "liquide",
            "lisière",
            "lister",
            "lithium",
            "litige",
            "littoral",
            "livreur",
            "logique",
            "lointain",
            "loisir",
            "lombric",
            "loterie",
            "louer",
            "lourd",
            "loutre",
            "louve",
            "loyal",
            "lubie",
            "lucide",
            "lucratif",
            "lueur",
            "lugubre",
            "luisant",
            "lumière",
            "lunaire",
            "lundi",
            "luron",
            "lutter",
            "luxueux",
            "machine",
            "magasin",
            "magenta",
            "magique",
            "maigre",
            "maillon",
            "maintien",
            "mairie",
            "maison",
            "majorer",
            "malaxer",
            "maléfice",
            "malheur",
            "malice",
            "mallette",
            "mammouth",
            "mandater",
            "maniable",
            "manquant",
            "manteau",
            "manuel",
            "marathon",
            "marbre",
            "marchand",
            "mardi",
            "maritime",
            "marqueur",
            "marron",
            "marteler",
            "mascotte",
            "massif",
            "matériel",
            "matière",
            "matraque",
            "maudire",
            "maussade",
            "mauve",
            "maximal",
            "méchant",
            "méconnu",
            "médaille",
            "médecin",
            "méditer",
            "méduse",
            "meilleur",
            "mélange",
            "mélodie",
            "membre",
            "mémoire",
            "menacer",
            "mener",
            "menhir",
            "mensonge",
            "mentor",
            "mercredi",
            "mérite",
            "merle",
            "messager",
            "mesure",
            "métal",
            "météore",
            "méthode",
            "métier",
            "meuble",
            "miauler",
            "microbe",
            "miette",
            "mignon",
            "migrer",
            "milieu",
            "million",
            "mimique",
            "mince",
            "minéral",
            "minimal",
            "minorer",
            "minute",
            "miracle",
            "miroiter",
            "missile",
            "mixte",
            "mobile",
            "moderne",
            "moelleux",
            "mondial",
            "moniteur",
            "monnaie",
            "monotone",
            "monstre",
            "montagne",
            "monument",
            "moqueur",
            "morceau",
            "morsure",
            "mortier",
            "moteur",
            "motif",
            "mouche",
            "moufle",
            "moulin",
            "mousson",
            "mouton",
            "mouvant",
            "multiple",
            "munition",
            "muraille",
            "murène",
            "murmure",
            "muscle",
            "muséum",
            "musicien",
            "mutation",
            "muter",
            "mutuel",
            "myriade",
            "myrtille",
            "mystère",
            "mythique",
            "nageur",
            "nappe",
            "narquois",
            "narrer",
            "natation",
            "nation",
            "nature",
            "naufrage",
            "nautique",
            "navire",
            "nébuleux",
            "nectar",
            "néfaste",
            "négation",
            "négliger",
            "négocier",
            "neige",
            "nerveux",
            "nettoyer",
            "neurone",
            "neutron",
            "neveu",
            "niche",
            "nickel",
            "nitrate",
            "niveau",
            "noble",
            "nocif",
            "nocturne",
            "noirceur",
            "noisette",
            "nomade",
            "nombreux",
            "nommer",
            "normatif",
            "notable",
            "notifier",
            "notoire",
            "nourrir",
            "nouveau",
            "novateur",
            "novembre",
            "novice",
            "nuage",
            "nuancer",
            "nuire",
            "nuisible",
            "numéro",
            "nuptial",
            "nuque",
            "nutritif",
            "obéir",
            "objectif",
            "obliger",
            "obscur",
            "observer",
            "obstacle",
            "obtenir",
            "obturer",
            "occasion",
            "occuper",
            "océan",
            "octobre",
            "octroyer",
            "octupler",
            "oculaire",
            "odeur",
            "odorant",
            "offenser",
            "officier",
            "offrir",
            "ogive",
            "oiseau",
            "oisillon",
            "olfactif",
            "olivier",
            "ombrage",
            "omettre",
            "onctueux",
            "onduler",
            "onéreux",
            "onirique",
            "opale",
            "opaque",
            "opérer",
            "opinion",
            "opportun",
            "opprimer",
            "opter",
            "optique",
            "orageux",
            "orange",
            "orbite",
            "ordonner",
            "oreille",
            "organe",
            "orgueil",
            "orifice",
            "ornement",
            "orque",
            "ortie",
            "osciller",
            "osmose",
            "ossature",
            "otarie",
            "ouragan",
            "ourson",
            "outil",
            "outrager",
            "ouvrage",
            "ovation",
            "oxyde",
            "oxygène",
            "ozone",
            "paisible",
            "palace",
            "palmarès",
            "palourde",
            "palper",
            "panache",
            "panda",
            "pangolin",
            "paniquer",
            "panneau",
            "panorama",
            "pantalon",
            "papaye",
            "papier",
            "papoter",
            "papyrus",
            "paradoxe",
            "parcelle",
            "paresse",
            "parfumer",
            "parler",
            "parole",
            "parrain",
            "parsemer",
            "partager",
            "parure",
            "parvenir",
            "passion",
            "pastèque",
            "paternel",
            "patience",
            "patron",
            "pavillon",
            "pavoiser",
            "payer",
            "paysage",
            "peigne",
            "peintre",
            "pelage",
            "pélican",
            "pelle",
            "pelouse",
            "peluche",
            "pendule",
            "pénétrer",
            "pénible",
            "pensif",
            "pénurie",
            "pépite",
            "péplum",
            "perdrix",
            "perforer",
            "période",
            "permuter",
            "perplexe",
            "persil",
            "perte",
            "peser",
            "pétale",
            "petit",
            "pétrir",
            "peuple",
            "pharaon",
            "phobie",
            "phoque",
            "photon",
            "phrase",
            "physique",
            "piano",
            "pictural",
            "pièce",
            "pierre",
            "pieuvre",
            "pilote",
            "pinceau",
            "pipette",
            "piquer",
            "pirogue",
            "piscine",
            "piston",
            "pivoter",
            "pixel",
            "pizza",
            "placard",
            "plafond",
            "plaisir",
            "planer",
            "plaque",
            "plastron",
            "plateau",
            "pleurer",
            "plexus",
            "pliage",
            "plomb",
            "plonger",
            "pluie",
            "plumage",
            "pochette",
            "poésie",
            "poète",
            "pointe",
            "poirier",
            "poisson",
            "poivre",
            "polaire",
            "policier",
            "pollen",
            "polygone",
            "pommade",
            "pompier",
            "ponctuel",
            "pondérer",
            "poney",
            "portique",
            "position",
            "posséder",
            "posture",
            "potager",
            "poteau",
            "potion",
            "pouce",
            "poulain",
            "poumon",
            "pourpre",
            "poussin",
            "pouvoir",
            "prairie",
            "pratique",
            "précieux",
            "prédire",
            "préfixe",
            "prélude",
            "prénom",
            "présence",
            "prétexte",
            "prévoir",
            "primitif",
            "prince",
            "prison",
            "priver",
            "problème",
            "procéder",
            "prodige",
            "profond",
            "progrès",
            "proie",
            "projeter",
            "prologue",
            "promener",
            "propre",
            "prospère",
            "protéger",
            "prouesse",
            "proverbe",
            "prudence",
            "pruneau",
            "psychose",
            "public",
            "puceron",
            "puiser",
            "pulpe",
            "pulsar",
            "punaise",
            "punitif",
            "pupitre",
            "purifier",
            "puzzle",
            "pyramide",
            "quasar",
            "querelle",
            "question",
            "quiétude",
            "quitter",
            "quotient",
            "racine",
            "raconter",
            "radieux",
            "ragondin",
            "raideur",
            "raisin",
            "ralentir",
            "rallonge",
            "ramasser",
            "rapide",
            "rasage",
            "ratisser",
            "ravager",
            "ravin",
            "rayonner",
            "réactif",
            "réagir",
            "réaliser",
            "réanimer",
            "recevoir",
            "réciter",
            "réclamer",
            "récolter",
            "recruter",
            "reculer",
            "recycler",
            "rédiger",
            "redouter",
            "refaire",
            "réflexe",
            "réformer",
            "refrain",
            "refuge",
            "régalien",
            "région",
            "réglage",
            "régulier",
            "réitérer",
            "rejeter",
            "rejouer",
            "relatif",
            "relever",
            "relief",
            "remarque",
            "remède",
            "remise",
            "remonter",
            "remplir",
            "remuer",
            "renard",
            "renfort",
            "renifler",
            "renoncer",
            "rentrer",
            "renvoi",
            "replier",
            "reporter",
            "reprise",
            "reptile",
            "requin",
            "réserve",
            "résineux",
            "résoudre",
            "respect",
            "rester",
            "résultat",
            "rétablir",
            "retenir",
            "réticule",
            "retomber",
            "retracer",
            "réunion",
            "réussir",
            "revanche",
            "revivre",
            "révolte",
            "révulsif",
            "richesse",
            "rideau",
            "rieur",
            "rigide",
            "rigoler",
            "rincer",
            "riposter",
            "risible",
            "risque",
            "rituel",
            "rival",
            "rivière",
            "rocheux",
            "romance",
            "rompre",
            "ronce",
            "rondin",
            "roseau",
            "rosier",
            "rotatif",
            "rotor",
            "rotule",
            "rouge",
            "rouille",
            "rouleau",
            "routine",
            "royaume",
            "ruban",
            "rubis",
            "ruche",
            "ruelle",
            "rugueux",
            "ruiner",
            "ruisseau",
            "ruser",
            "rustique",
            "rythme",
            "sabler",
            "saboter",
            "sabre",
            "sacoche",
            "safari",
            "sagesse",
            "saisir",
            "salade",
            "salive",
            "salon",
            "saluer",
            "samedi",
            "sanction",
            "sanglier",
            "sarcasme",
            "sardine",
            "saturer",
            "saugrenu",
            "saumon",
            "sauter",
            "sauvage",
            "savant",
            "savonner",
            "scalpel",
            "scandale",
            "scélérat",
            "scénario",
            "sceptre",
            "schéma",
            "science",
            "scinder",
            "score",
            "scrutin",
            "sculpter",
            "séance",
            "sécable",
            "sécher",
            "secouer",
            "sécréter",
            "sédatif",
            "séduire",
            "seigneur",
            "séjour",
            "sélectif",
            "semaine",
            "sembler",
            "semence",
            "séminal",
            "sénateur",
            "sensible",
            "sentence",
            "séparer",
            "séquence",
            "serein",
            "sergent",
            "sérieux",
            "serrure",
            "sérum",
            "service",
            "sésame",
            "sévir",
            "sevrage",
            "sextuple",
            "sidéral",
            "siècle",
            "siéger",
            "siffler",
            "sigle",
            "signal",
            "silence",
            "silicium",
            "simple",
            "sincère",
            "sinistre",
            "siphon",
            "sirop",
            "sismique",
            "situer",
            "skier",
            "social",
            "socle",
            "sodium",
            "soigneux",
            "soldat",
            "soleil",
            "solitude",
            "soluble",
            "sombre",
            "sommeil",
            "somnoler",
            "sonde",
            "songeur",
            "sonnette",
            "sonore",
            "sorcier",
            "sortir",
            "sosie",
            "sottise",
            "soucieux",
            "soudure",
            "souffle",
            "soulever",
            "soupape",
            "source",
            "soutirer",
            "souvenir",
            "spacieux",
            "spatial",
            "spécial",
            "sphère",
            "spiral",
            "stable",
            "station",
            "sternum",
            "stimulus",
            "stipuler",
            "strict",
            "studieux",
            "stupeur",
            "styliste",
            "sublime",
            "substrat",
            "subtil",
            "subvenir",
            "succès",
            "sucre",
            "suffixe",
            "suggérer",
            "suiveur",
            "sulfate",
            "superbe",
            "supplier",
            "surface",
            "suricate",
            "surmener",
            "surprise",
            "sursaut",
            "survie",
            "suspect",
            "syllabe",
            "symbole",
            "symétrie",
            "synapse",
            "syntaxe",
            "système",
            "tabac",
            "tablier",
            "tactile",
            "tailler",
            "talent",
            "talisman",
            "talonner",
            "tambour",
            "tamiser",
            "tangible",
            "tapis",
            "taquiner",
            "tarder",
            "tarif",
            "tartine",
            "tasse",
            "tatami",
            "tatouage",
            "taupe",
            "taureau",
            "taxer",
            "témoin",
            "temporel",
            "tenaille",
            "tendre",
            "teneur",
            "tenir",
            "tension",
            "terminer",
            "terne",
            "terrible",
            "tétine",
            "texte",
            "thème",
            "théorie",
            "thérapie",
            "thorax",
            "tibia",
            "tiède",
            "timide",
            "tirelire",
            "tiroir",
            "tissu",
            "titane",
            "titre",
            "tituber",
            "toboggan",
            "tolérant",
            "tomate",
            "tonique",
            "tonneau",
            "toponyme",
            "torche",
            "tordre",
            "tornade",
            "torpille",
            "torrent",
            "torse",
            "tortue",
            "totem",
            "toucher",
            "tournage",
            "tousser",
            "toxine",
            "traction",
            "trafic",
            "tragique",
            "trahir",
            "train",
            "trancher",
            "travail",
            "trèfle",
            "tremper",
            "trésor",
            "treuil",
            "triage",
            "tribunal",
            "tricoter",
            "trilogie",
            "triomphe",
            "tripler",
            "triturer",
            "trivial",
            "trombone",
            "tronc",
            "tropical",
            "troupeau",
            "tuile",
            "tulipe",
            "tumulte",
            "tunnel",
            "turbine",
            "tuteur",
            "tutoyer",
            "tuyau",
            "tympan",
            "typhon",
            "typique",
            "tyran",
            "ubuesque",
            "ultime",
            "ultrason",
            "unanime",
            "unifier",
            "union",
            "unique",
            "unitaire",
            "univers",
            "uranium",
            "urbain",
            "urticant",
            "usage",
            "usine",
            "usuel",
            "usure",
            "utile",
            "utopie",
            "vacarme",
            "vaccin",
            "vagabond",
            "vague",
            "vaillant",
            "vaincre",
            "vaisseau",
            "valable",
            "valise",
            "vallon",
            "valve",
            "vampire",
            "vanille",
            "vapeur",
            "varier",
            "vaseux",
            "vassal",
            "vaste",
            "vecteur",
            "vedette",
            "végétal",
            "véhicule",
            "veinard",
            "véloce",
            "vendredi",
            "vénérer",
            "venger",
            "venimeux",
            "ventouse",
            "verdure",
            "vérin",
            "vernir",
            "verrou",
            "verser",
            "vertu",
            "veston",
            "vétéran",
            "vétuste",
            "vexant",
            "vexer",
            "viaduc",
            "viande",
            "victoire",
            "vidange",
            "vidéo",
            "vignette",
            "vigueur",
            "vilain",
            "village",
            "vinaigre",
            "violon",
            "vipère",
            "virement",
            "virtuose",
            "virus",
            "visage",
            "viseur",
            "vision",
            "visqueux",
            "visuel",
            "vital",
            "vitesse",
            "viticole",
            "vitrine",
            "vivace",
            "vivipare",
            "vocation",
            "voguer",
            "voile",
            "voisin",
            "voiture",
            "volaille",
            "volcan",
            "voltiger",
            "volume",
            "vorace",
            "vortex",
            "voter",
            "vouloir",
            "voyage",
            "voyelle",
            "wagon",
            "xénon",
            "yacht",
            "zèbre",
            "zénith",
            "zeste",
            "zoologie"
    };
}