/*
 * Decompiled with CFR 0.152.
 */
package io.github.novacrypto.bip39;

import io.github.novacrypto.bip39.Normalization;
import io.github.novacrypto.bip39.PBKDF2WithHmacSHA512;
import io.github.novacrypto.bip39.SeedCalculatorByWordListLookUp;
import io.github.novacrypto.bip39.SpongyCastlePBKDF2WithHmacSHA512;
import io.github.novacrypto.bip39.WordList;
import io.github.novacrypto.toruntime.CheckedExceptionToRuntime;
import java.util.Arrays;

public final class SeedCalculator {
    private final byte[] fixedSalt = SeedCalculator.getUtf8Bytes("mnemonic");
    private final PBKDF2WithHmacSHA512 hashAlgorithm;

    public SeedCalculator(PBKDF2WithHmacSHA512 hashAlgorithm) {
        this.hashAlgorithm = hashAlgorithm;
    }

    public SeedCalculator() {
        this(SpongyCastlePBKDF2WithHmacSHA512.INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] calculateSeed(String mnemonic, String passphrase) {
        char[] chars = Normalization.normalizeNFKD(mnemonic).toCharArray();
        try {
            byte[] byArray = this.calculateSeed(chars, passphrase);
            return byArray;
        }
        finally {
            Arrays.fill(chars, '\u0000');
        }
    }

    byte[] calculateSeed(char[] mnemonicChars, String passphrase) {
        String normalizedPassphrase = Normalization.normalizeNFKD(passphrase);
        byte[] salt2 = SeedCalculator.getUtf8Bytes(normalizedPassphrase);
        byte[] salt = SeedCalculator.combine(this.fixedSalt, salt2);
        SeedCalculator.clear(salt2);
        byte[] encoded = this.hash(mnemonicChars, salt);
        SeedCalculator.clear(salt);
        return encoded;
    }

    public SeedCalculatorByWordListLookUp withWordsFromWordList(WordList wordList) {
        return new SeedCalculatorByWordListLookUp(this, wordList);
    }

    private static byte[] combine(byte[] array1, byte[] array2) {
        byte[] bytes = new byte[array1.length + array2.length];
        System.arraycopy(array1, 0, bytes, 0, array1.length);
        System.arraycopy(array2, 0, bytes, array1.length, bytes.length - array1.length);
        return bytes;
    }

    private static void clear(byte[] salt) {
        Arrays.fill(salt, (byte)0);
    }

    private byte[] hash(char[] chars, byte[] salt) {
        return this.hashAlgorithm.hash(chars, salt);
    }

    private static byte[] getUtf8Bytes(final String string) {
        return (byte[])CheckedExceptionToRuntime.toRuntime((CheckedExceptionToRuntime.Func)new CheckedExceptionToRuntime.Func<byte[]>(){

            public byte[] run() throws Exception {
                return string.getBytes("UTF-8");
            }
        });
    }
}

