/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomisRev.kafka;

import com.github.nomisRev.kafka.Acks;
import com.github.nomisRev.kafka.Producer;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.flow.Flow;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B3\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\nH\u00c6\u0003JI\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0018\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001f0\u001eJ\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/github/nomisRev/kafka/ProducerSettings;", "K", "V", "", "bootstrapServers", "", "keyDeserializer", "Lorg/apache/kafka/common/serialization/Serializer;", "valueDeserializer", "acks", "Lcom/github/nomisRev/kafka/Acks;", "(Ljava/lang/String;Lorg/apache/kafka/common/serialization/Serializer;Lorg/apache/kafka/common/serialization/Serializer;Lcom/github/nomisRev/kafka/Acks;)V", "getAcks", "()Lcom/github/nomisRev/kafka/Acks;", "getBootstrapServers", "()Ljava/lang/String;", "getKeyDeserializer", "()Lorg/apache/kafka/common/serialization/Serializer;", "getValueDeserializer", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "kafkaProducer", "Lkotlinx/coroutines/flow/Flow;", "Lorg/apache/kafka/clients/producer/KafkaProducer;", "properties", "Ljava/util/Properties;", "toString", "kotlin-kafka"})
public final class ProducerSettings<K, V> {
    @NotNull
    private final String bootstrapServers;
    @NotNull
    private final Serializer<K> keyDeserializer;
    @NotNull
    private final Serializer<V> valueDeserializer;
    @NotNull
    private final Acks acks;

    public ProducerSettings(@NotNull String bootstrapServers, @NotNull Serializer<K> keyDeserializer, @NotNull Serializer<V> valueDeserializer, @NotNull Acks acks) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)((Object)acks), (String)"acks");
        this.bootstrapServers = bootstrapServers;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.acks = acks;
    }

    public /* synthetic */ ProducerSettings(String string, Serializer serializer, Serializer serializer2, Acks acks, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            acks = Acks.One;
        }
        this(string, serializer, serializer2, acks);
    }

    @NotNull
    public final String getBootstrapServers() {
        return this.bootstrapServers;
    }

    @NotNull
    public final Serializer<K> getKeyDeserializer() {
        return this.keyDeserializer;
    }

    @NotNull
    public final Serializer<V> getValueDeserializer() {
        return this.valueDeserializer;
    }

    @NotNull
    public final Acks getAcks() {
        return this.acks;
    }

    @NotNull
    public final Properties properties() {
        Properties properties2;
        Properties $this$properties_u24lambda_u2d0 = properties2 = new Properties();
        boolean bl = false;
        $this$properties_u24lambda_u2d0.put("bootstrap.servers", this.bootstrapServers);
        $this$properties_u24lambda_u2d0.put("key.serializer", Reflection.getOrCreateKotlinClass(this.keyDeserializer.getClass()).getQualifiedName());
        $this$properties_u24lambda_u2d0.put("value.serializer", Reflection.getOrCreateKotlinClass(this.valueDeserializer.getClass()).getQualifiedName());
        $this$properties_u24lambda_u2d0.put("acks", this.acks.getValue());
        return properties2;
    }

    @NotNull
    public final Flow<KafkaProducer<K, V>> kafkaProducer() {
        return Producer.kafkaProducer(this.properties(), this.keyDeserializer, this.valueDeserializer);
    }

    @NotNull
    public final String component1() {
        return this.bootstrapServers;
    }

    @NotNull
    public final Serializer<K> component2() {
        return this.keyDeserializer;
    }

    @NotNull
    public final Serializer<V> component3() {
        return this.valueDeserializer;
    }

    @NotNull
    public final Acks component4() {
        return this.acks;
    }

    @NotNull
    public final ProducerSettings<K, V> copy(@NotNull String bootstrapServers, @NotNull Serializer<K> keyDeserializer, @NotNull Serializer<V> valueDeserializer, @NotNull Acks acks) {
        Intrinsics.checkNotNullParameter((Object)bootstrapServers, (String)"bootstrapServers");
        Intrinsics.checkNotNullParameter(keyDeserializer, (String)"keyDeserializer");
        Intrinsics.checkNotNullParameter(valueDeserializer, (String)"valueDeserializer");
        Intrinsics.checkNotNullParameter((Object)((Object)acks), (String)"acks");
        return new ProducerSettings<K, V>(bootstrapServers, keyDeserializer, valueDeserializer, acks);
    }

    public static /* synthetic */ ProducerSettings copy$default(ProducerSettings producerSettings, String string, Serializer serializer, Serializer serializer2, Acks acks, int n, Object object) {
        if ((n & 1) != 0) {
            string = producerSettings.bootstrapServers;
        }
        if ((n & 2) != 0) {
            serializer = producerSettings.keyDeserializer;
        }
        if ((n & 4) != 0) {
            serializer2 = producerSettings.valueDeserializer;
        }
        if ((n & 8) != 0) {
            acks = producerSettings.acks;
        }
        return producerSettings.copy(string, serializer, serializer2, acks);
    }

    @NotNull
    public String toString() {
        return "ProducerSettings(bootstrapServers=" + this.bootstrapServers + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", acks=" + (Object)((Object)this.acks) + ')';
    }

    public int hashCode() {
        int result = this.bootstrapServers.hashCode();
        result = result * 31 + this.keyDeserializer.hashCode();
        result = result * 31 + this.valueDeserializer.hashCode();
        result = result * 31 + this.acks.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProducerSettings)) {
            return false;
        }
        ProducerSettings producerSettings = (ProducerSettings)other;
        if (!Intrinsics.areEqual((Object)this.bootstrapServers, (Object)producerSettings.bootstrapServers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.keyDeserializer, producerSettings.keyDeserializer)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.valueDeserializer, producerSettings.valueDeserializer)) {
            return false;
        }
        return this.acks == producerSettings.acks;
    }
}

