/*
 * Decompiled with CFR 0.152.
 */
package com.github.nomisRev.kafka;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00020\u0003B'\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\r2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0002\b\u0003\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001f\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0018J)\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u001bR\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lcom/github/nomisRev/kafka/MappedSerializer;", "A", "B", "Lorg/apache/kafka/common/serialization/Serializer;", "original", "imap", "Lkotlin/Function1;", "(Lorg/apache/kafka/common/serialization/Serializer;Lkotlin/jvm/functions/Function1;)V", "getImap", "()Lkotlin/jvm/functions/Function1;", "getOriginal", "()Lorg/apache/kafka/common/serialization/Serializer;", "close", "", "configure", "configs", "", "", "isKey", "", "serialize", "", "topic", "data", "(Ljava/lang/String;Ljava/lang/Object;)[B", "headers", "Lorg/apache/kafka/common/header/Headers;", "(Ljava/lang/String;Lorg/apache/kafka/common/header/Headers;Ljava/lang/Object;)[B", "kotlin-kafka"})
final class MappedSerializer<A, B>
implements Serializer<B> {
    @NotNull
    private final Serializer<A> original;
    @NotNull
    private final Function1<B, A> imap;

    public MappedSerializer(@NotNull Serializer<A> original, @NotNull Function1<? super B, ? extends A> imap) {
        Intrinsics.checkNotNullParameter(original, (String)"original");
        Intrinsics.checkNotNullParameter(imap, (String)"imap");
        this.original = original;
        this.imap = imap;
    }

    @NotNull
    public final Serializer<A> getOriginal() {
        return this.original;
    }

    @NotNull
    public final Function1<B, A> getImap() {
        return this.imap;
    }

    public void close() {
        this.original.close();
    }

    public void configure(@Nullable Map<String, ?> configs, boolean isKey) {
        this.original.configure(configs, isKey);
    }

    @NotNull
    public byte[] serialize(@Nullable String topic, @Nullable Headers headers, B data) {
        byte[] byArray = this.original.serialize(topic, headers, this.imap.invoke(data));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"original.serialize(topic, headers, imap(data))");
        return byArray;
    }

    @NotNull
    public byte[] serialize(@Nullable String topic, B data) {
        byte[] byArray = this.original.serialize(topic, this.imap.invoke(data));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"original.serialize(topic, imap(data))");
        return byArray;
    }
}

